/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.memory.MemoryFence;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=IsJSObjectNode.class)
public final class IsJSObjectNodeGen
extends IsJSObjectNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private IsObjectCachedData isObjectCached_cache;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile isObject_resultProfile_;

    private IsJSObjectNodeGen(boolean includeNullUndefined) {
        super(includeNullUndefined);
    }

    @Override
    @ExplodeLoop
    public boolean executeBoolean(Object arg0Value) {
        int state_0 = this.state_0_;
        if (state_0 != 0) {
            if ((state_0 & 1) != 0) {
                IsObjectCachedData s0_ = this.isObjectCached_cache;
                while (s0_ != null) {
                    assert (s0_.cachedClass_ != null);
                    if (s0_.cachedClass_.isInstance(arg0Value)) {
                        return IsJSObjectNode.isObjectCached(arg0Value, s0_.cachedClass_, s0_.cachedResult_);
                    }
                    s0_ = s0_.next_;
                }
            }
            if ((state_0 & 2) != 0) {
                return this.isObject(arg0Value, this.isObject_resultProfile_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        try {
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            if (exclude == 0) {
                Class<?> cachedClass__;
                int count0_ = 0;
                IsObjectCachedData s0_ = this.isObjectCached_cache;
                if ((state_0 & 1) != 0) {
                    while (s0_ != null) {
                        assert (s0_.cachedClass_ != null);
                        if (s0_.cachedClass_.isInstance(arg0Value)) break;
                        s0_ = s0_.next_;
                        ++count0_;
                    }
                }
                if (s0_ == null && (cachedClass__ = JSGuards.getClassIfJSDynamicObject(arg0Value)) != null && cachedClass__.isInstance(arg0Value) && count0_ < 1) {
                    s0_ = new IsObjectCachedData(this.isObjectCached_cache);
                    s0_.cachedClass_ = cachedClass__;
                    s0_.cachedResult_ = this.guardIsJSObject(arg0Value);
                    MemoryFence.storeStore();
                    this.isObjectCached_cache = s0_;
                    this.state_0_ = state_0 |= 1;
                }
                if (s0_ != null) {
                    lock.unlock();
                    hasLock = false;
                    boolean bl = IsJSObjectNode.isObjectCached(arg0Value, s0_.cachedClass_, s0_.cachedResult_);
                    return bl;
                }
            }
            this.isObject_resultProfile_ = ConditionProfile.createBinaryProfile();
            this.exclude_ = exclude |= 1;
            this.isObjectCached_cache = null;
            state_0 &= 0xFFFFFFFE;
            this.state_0_ = state_0 |= 2;
            lock.unlock();
            hasLock = false;
            boolean bl = this.isObject(arg0Value, this.isObject_resultProfile_);
            return bl;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        IsObjectCachedData s0_;
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0 && ((s0_ = this.isObjectCached_cache) == null || s0_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Serializable>> cached;
        Object[] data = new Object[3];
        data[0] = 0;
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "isObjectCached";
        if ((state_0 & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Serializable>>();
            IsObjectCachedData s0_ = this.isObjectCached_cache;
            while (s0_ != null) {
                cached.add(Arrays.asList(s0_.cachedClass_, s0_.cachedResult_));
                s0_ = s0_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "isObject";
        if ((state_0 & 2) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.isObject_resultProfile_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[2] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static IsJSObjectNode create(boolean includeNullUndefined) {
        return new IsJSObjectNodeGen(includeNullUndefined);
    }

    @GeneratedBy(value=IsJSObjectNode.class)
    private static final class IsObjectCachedData {
        @CompilerDirectives.CompilationFinal
        IsObjectCachedData next_;
        @CompilerDirectives.CompilationFinal
        Class<?> cachedClass_;
        @CompilerDirectives.CompilationFinal
        boolean cachedResult_;

        IsObjectCachedData(IsObjectCachedData next_) {
            this.next_ = next_;
        }
    }
}

