/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transforms.tabular.serialization;

import com.paterva.maltego.transforms.tabular.data.TabularTransform;
import com.paterva.maltego.transforms.tabular.data.TabularTransformEntityNames;
import com.paterva.maltego.transforms.tabular.data.TabularTransformSource;
import com.paterva.maltego.transforms.tabular.serialization.EntityNameStub;
import com.paterva.maltego.transforms.tabular.serialization.EntityNamesStub;
import com.paterva.maltego.transforms.tabular.serialization.TabularTransformSourceStub;
import com.paterva.maltego.transforms.tabular.serialization.TabularTransformStub;
import com.paterva.maltego.transforms.tabular.serialization.TabularTransformsStub;
import com.paterva.maltego.transforms.tabular.serialization.TransformSourceFileStub;
import com.paterva.maltego.util.Args;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

class TabularTransformTranslator {
    TabularTransformTranslator() {
    }

    public TabularTransformSource translate(TabularTransformSourceStub stub) {
        Args.notNull((Object)stub, (String)"stub");
        String name = stub.getName();
        String displayName = stub.getDisplayName();
        String tabularGraphName = stub.getTabularGraphName();
        List<String> sourceFiles = this.translateFilesStub(stub.getSourceFiles());
        List<TabularTransform> transforms = this.translate(stub.getTransforms());
        TabularTransformEntityNames entityNames = this.translate(stub.getEntityNames());
        boolean searchFavorited = stub.isSearchFavorited();
        return new TabularTransformSource(name, displayName, tabularGraphName, sourceFiles, transforms, entityNames, searchFavorited);
    }

    public TabularTransformSourceStub translate(TabularTransformSource txSource) {
        Args.notNull((Object)((Object)txSource), (String)"txSource");
        TabularTransformSourceStub stub = new TabularTransformSourceStub();
        stub.setName(txSource.getName());
        stub.setDisplayName(txSource.getDisplayName());
        stub.setTabularGraphName(txSource.getTabularGraphName());
        stub.setSourceFiles(this.translateFiles(txSource.getSourceFiles()));
        stub.setTransforms(this.translateTransforms(txSource.getTabularTransforms()));
        stub.setEntityNames(this.translate(txSource.getEntityNames()));
        stub.setSearchFavorited(txSource.isSearchFavorited());
        return stub;
    }

    private List<TabularTransform> translate(TabularTransformsStub stub) {
        Args.notNull((Object)stub, (String)"stub");
        return stub.getTransforms().stream().map(this::translate).collect(Collectors.toList());
    }

    private TabularTransform translate(TabularTransformStub stub) {
        Args.notNull((Object)stub, (String)"stub");
        List<Integer> linkIndexes = stub.getLinkIndexes();
        boolean reverse = stub.isReverse();
        boolean favorite = stub.isFavorite();
        return new TabularTransform(linkIndexes, reverse, favorite);
    }

    private TabularTransformEntityNames translate(EntityNamesStub stub) {
        Args.notNull((Object)stub, (String)"stub");
        return new TabularTransformEntityNames(stub.getEntityNames().stream().collect(Collectors.toMap(entityName -> entityName.getFirstColumn(), entityName -> entityName.getName())));
    }

    private List<TransformSourceFileStub> translateFiles(List<String> sourceFiles) {
        Args.notNull(sourceFiles, (String)"sourceFiles");
        return sourceFiles.stream().filter(StringUtils::isNotBlank).map(filesText -> {
            TransformSourceFileStub stub = new TransformSourceFileStub();
            stub.setFilesText((String)filesText);
            return stub;
        }).collect(Collectors.toList());
    }

    private TabularTransformsStub translateTransforms(List<TabularTransform> transforms) {
        Args.notNull(transforms, (String)"transforms");
        List<TabularTransformStub> transformStubs = transforms.stream().map(this::translate).collect(Collectors.toList());
        TabularTransformsStub stub = new TabularTransformsStub();
        stub.setTransforms(transformStubs);
        return stub;
    }

    private TabularTransformStub translate(TabularTransform transform) {
        Args.notNull((Object)transform, (String)"transform");
        TabularTransformStub stub = new TabularTransformStub();
        stub.setLinkIndexes(transform.getLinkIndexes());
        stub.setReverse(transform.isReverse());
        stub.setFavorite(transform.isFavorite());
        return stub;
    }

    private EntityNamesStub translate(TabularTransformEntityNames entityNames) {
        Args.notNull((Object)entityNames, (String)"entityNames");
        List<EntityNameStub> entityNameStubs = entityNames.getFirstColumns().stream().map(firstColumn -> this.translate(entityNames, (int)firstColumn)).collect(Collectors.toList());
        EntityNamesStub stub = new EntityNamesStub();
        stub.setEntityNames(entityNameStubs);
        return stub;
    }

    private EntityNameStub translate(TabularTransformEntityNames entityNames, int firstColumn) {
        Args.notNull((Object)entityNames, (String)"entityNames");
        EntityNameStub stub = new EntityNameStub();
        stub.setFirstColumn(firstColumn);
        stub.setName(entityNames.getName(firstColumn).get());
        return stub;
    }

    private List<String> translateFilesStub(List<TransformSourceFileStub> sourceFiles) {
        Args.notNull(sourceFiles, (String)"sourceFiles");
        return sourceFiles.stream().map(stub -> stub.getFilesText()).collect(Collectors.toList());
    }
}

