/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.xsocket.DataConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ComposedByteBuffer {
    private ArrayList<ByteBuffer> buffers = new ArrayList();
    private int bufferIdx;
    private ByteBuffer currentBuffer = null;
    private int remainingCurrentBuffer;
    private int remainingTotal;

    ComposedByteBuffer() {
    }

    void append(ByteBuffer[] bufs) {
        if (bufs == null) {
            return;
        }
        for (ByteBuffer byteBuffer : bufs) {
            if (byteBuffer == null || !byteBuffer.hasRemaining()) continue;
            this.remainingTotal += byteBuffer.remaining();
            if (this.buffers.size() == 0) {
                this.currentBuffer = bufs[0];
                this.remainingCurrentBuffer = this.currentBuffer.remaining();
            }
            this.buffers.add(byteBuffer);
        }
    }

    void addFirst(byte[] data) {
        List<ByteBuffer> buffers = this.drain();
        this.clear();
        this.append(new ByteBuffer[]{ByteBuffer.wrap(data)});
        this.append(buffers.toArray(new ByteBuffer[buffers.size()]));
    }

    void readByteBufferByLength(int length, IBufferSink bufferSink) throws IOException {
        if (this.remainingCurrentBuffer == 0) {
            ++this.bufferIdx;
            this.currentBuffer = this.buffers.get(this.bufferIdx);
            this.remainingCurrentBuffer = this.currentBuffer.remaining();
        }
        if (this.remainingCurrentBuffer == length) {
            bufferSink.add(this.currentBuffer);
            this.remainingTotal -= this.remainingCurrentBuffer;
            this.remainingCurrentBuffer = 0;
        } else if (this.remainingCurrentBuffer < length) {
            int remainingRequired = length - this.remainingCurrentBuffer;
            bufferSink.add(this.currentBuffer);
            this.remainingTotal -= this.remainingCurrentBuffer;
            this.remainingCurrentBuffer = 0;
            this.readByteBufferByLength(remainingRequired, bufferSink);
        } else {
            int savedLimit = this.currentBuffer.limit();
            this.currentBuffer.limit(this.currentBuffer.position() + length);
            ByteBuffer sliced = this.currentBuffer.slice();
            bufferSink.add(sliced);
            this.currentBuffer.position(this.currentBuffer.limit());
            this.currentBuffer.limit(savedLimit);
            this.remainingCurrentBuffer = this.currentBuffer.remaining();
            this.remainingTotal -= length;
        }
    }

    int indexOfBoundaryDelimiter(byte[] delimiter) {
        int state = 1;
        int pos = 0;
        int length = 0;
        for (int i = this.bufferIdx; i <= this.buffers.size(); ++i) {
            ByteBuffer buf = this.buffers.get(this.bufferIdx).duplicate();
            while (buf.hasRemaining()) {
                byte b = buf.get();
                ++length;
                switch (state) {
                    case 1: {
                        if (b == delimiter[pos]) {
                            if (++pos != delimiter.length) break;
                            state = 2;
                            break;
                        }
                        pos = 0;
                        break;
                    }
                    case 2: {
                        if (b == 9 || b == 32) break;
                        if (b == 13) {
                            state = 3;
                            break;
                        }
                        pos = 0;
                        state = 1;
                        break;
                    }
                    case 3: {
                        if (b == 9 || b == 32) break;
                        if (b == 10) {
                            return length;
                        }
                        pos = 0;
                        state = 1;
                        break;
                    }
                }
            }
        }
        return 0;
    }

    boolean isEmpty() {
        return this.remainingTotal == 0;
    }

    int remaining() {
        return this.remainingTotal;
    }

    List<ByteBuffer> drain() {
        ArrayList<ByteBuffer> result = null;
        if (this.bufferIdx == 0) {
            result = this.buffers;
            this.buffers = new ArrayList();
        } else {
            result = new ArrayList();
            for (int i = this.bufferIdx; i < this.buffers.size(); ++i) {
                result.add(this.buffers.get(i));
            }
            this.buffers = new ArrayList();
        }
        this.clear();
        return result;
    }

    int drain(IBufferSink bufferSink) throws IOException {
        int read = 0;
        for (int i = this.bufferIdx; i < this.buffers.size(); ++i) {
            ByteBuffer buffer = this.buffers.get(i);
            read += buffer.remaining();
            bufferSink.add(buffer);
        }
        this.clear();
        return read;
    }

    int available() {
        return this.remainingTotal;
    }

    byte getByte() {
        if (this.remainingCurrentBuffer > 0) {
            assert (this.currentBuffer == this.buffers.get(this.bufferIdx));
            --this.remainingTotal;
            --this.remainingCurrentBuffer;
            return this.currentBuffer.get();
        }
        ++this.bufferIdx;
        this.currentBuffer = this.buffers.get(this.bufferIdx);
        this.remainingCurrentBuffer = this.currentBuffer.remaining();
        return this.getByte();
    }

    void clear() {
        this.buffers.clear();
        this.bufferIdx = 0;
        this.currentBuffer = null;
        this.remainingCurrentBuffer = 0;
        this.remainingTotal = 0;
    }

    public String toString() {
        ArrayList<ByteBuffer> bufferCopy = new ArrayList<ByteBuffer>();
        for (int i = this.bufferIdx; i < this.buffers.size(); ++i) {
            bufferCopy.add(this.buffers.get(i).duplicate());
        }
        try {
            return DataConverter.toString(bufferCopy, (String)"US-ASCII");
        }
        catch (UnsupportedEncodingException use) {
            return DataConverter.toHexString(bufferCopy, (int)Integer.MAX_VALUE);
        }
    }

    static interface IBufferSink {
        public void add(ByteBuffer var1) throws IOException;
    }
}

