/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.types;

import java.util.Date;
import java.util.Objects;

public class DateRange {
    public static final Date MAX_DATE = new Date(Long.MAX_VALUE);
    public static final Date MIN_DATE = new Date(Long.MIN_VALUE);
    private Date _from;
    private Date _to;

    public DateRange(Date from, Date to) {
        this.setFrom(from);
        this.setTo(to);
    }

    public DateRange(long from, long to) {
        this(new Date(from), new Date(to));
    }

    public Date getFrom() {
        return this._from;
    }

    public final void setFrom(Date from) {
        if (from == null) {
            from = MIN_DATE;
        }
        this._from = from;
    }

    public Date getTo() {
        return this._to;
    }

    public final void setTo(Date to) {
        if (to == null) {
            to = MAX_DATE;
        }
        this._to = to;
    }

    public Date getCentre() {
        Date from = this._from;
        Date to = this._to;
        if (this.isForever()) {
            return null;
        }
        if (this.isSinceForever()) {
            from = to;
        }
        if (this.isUntilForever()) {
            to = from;
        }
        return new Date(from.getTime() + (to.getTime() - from.getTime()) / 2L);
    }

    public long getPeriodInMilliseconds() {
        return this._to.getTime() - this._from.getTime();
    }

    public int getPeriodInDays() {
        return (int)(this.getPeriodInMilliseconds() / 1000L / 60L / 60L / 24L);
    }

    public boolean isForever() {
        return this.equals(DateRange.forever());
    }

    public boolean isSinceForever() {
        return MIN_DATE.equals(this._from);
    }

    public boolean isUntilForever() {
        return MAX_DATE.equals(this._to);
    }

    public static DateRange forever() {
        return new DateRange(MIN_DATE, MAX_DATE);
    }

    public boolean contains(Date date) {
        return this.getFrom().getTime() <= date.getTime() && date.getTime() <= this.getTo().getTime();
    }

    public boolean contains(DateRange range) {
        return this.getFrom().getTime() <= range.getFrom().getTime() && range.getTo().getTime() <= this.getTo().getTime();
    }

    public boolean overlaps(DateRange range) {
        return this.getFrom().getTime() <= range.getTo().getTime() && this.getTo().getTime() >= range.getFrom().getTime();
    }

    public boolean within(DateRange range) {
        return this.getFrom().getTime() >= range.getFrom().getTime() && this.getTo().getTime() <= range.getTo().getTime();
    }

    public String toString() {
        String from = this.isSinceForever() ? "infinity" : this._from.toString();
        String to = this.isUntilForever() ? "infinity" : this._to.toString();
        return from + " - " + to;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Objects.hashCode(this._from);
        hash = 71 * hash + Objects.hashCode(this._to);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateRange other = (DateRange)obj;
        if (!Objects.equals(this._from, other._from)) {
            return false;
        }
        return Objects.equals(this._to, other._to);
    }
}

