/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.graph;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.ui.graph.transactions.GraphOperation;
import com.paterva.maltego.ui.graph.transactions.GraphTransaction;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionBatch;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import java.util.Iterator;

public class AddDeleteConflictResolver {
    public static GraphTransactionBatch resolve(GraphID graphID, GraphTransactionBatch batch) {
        GraphTransactionBatch resolved = new GraphTransactionBatch(batch.getDescription(), batch.isSignificant(), new GraphTransaction[0]);
        boolean hasDelete = false;
        boolean hasAdd = false;
        Iterator iterator = batch.getTransactions().iterator();
        while (iterator.hasNext()) {
            GraphTransaction transaction;
            GraphTransaction t = transaction = (GraphTransaction)iterator.next();
            if (transaction.getOperation() == GraphOperation.Delete) {
                hasDelete = true;
                t = GraphTransactionHelper.removeMissing((GraphID)graphID, (GraphTransaction)transaction);
            } else if (transaction.getOperation() == GraphOperation.Add) {
                hasAdd = true;
                if (!hasDelete) {
                    t = GraphTransactionHelper.removeExisting((GraphID)graphID, (GraphTransaction)transaction);
                }
            } else if (transaction.getOperation() == GraphOperation.Update && !hasAdd) {
                t = GraphTransactionHelper.removeMissing((GraphID)graphID, (GraphTransaction)transaction);
            }
            if (t.getEntityIDs().isEmpty() && t.getLinkIDs().isEmpty()) continue;
            resolved.add(t);
        }
        return resolved;
    }
}

