/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import java.util.List;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.utils.Base32;

public class RequiredActionHelper {
    private RequiredActionHelper() {
    }

    public static RequiredActionFactory getConfigurableRequiredActionFactory(KeycloakSession session, String providerId) {
        RequiredActionFactory providerFactory = (RequiredActionFactory)session.getKeycloakSessionFactory().getProviderFactory(RequiredActionProvider.class, providerId);
        if (providerFactory == null) {
            return null;
        }
        List configMetadata = providerFactory.getConfigMetadata();
        if (configMetadata != null && !configMetadata.isEmpty()) {
            return providerFactory;
        }
        return null;
    }

    public static RequiredActionFactory lookupConfigurableRequiredActionFactory(KeycloakSession session, String providerId) {
        RequiredActionFactory factory = RequiredActionHelper.getConfigurableRequiredActionFactory(session, providerId);
        if (factory == null) {
            providerId = new String(Base32.decode((String)providerId));
            factory = RequiredActionHelper.getConfigurableRequiredActionFactory(session, providerId);
        }
        return factory;
    }

    public static RequiredActionProviderModel getRequiredActionByProviderId(RealmModel realm, String providerId) {
        return realm.getRequiredActionProvidersStream().filter(action -> action.getProviderId().equals(providerId)).findFirst().orElse(null);
    }
}

