/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.welcome.impl;

import com.bulenkov.iconloader.util.SystemInfo;
import com.paterva.maltego.licensing.ui.LicenseWizardDisplayer;
import com.paterva.maltego.util.ui.dialog.UIRunQueue;
import com.paterva.maltego.util.ui.fonts.FontSizeDescriptor;
import com.paterva.maltego.util.ui.fonts.FontSizeRegistry;
import com.paterva.maltego.util.ui.fonts.OtherComponentsFontSize;
import com.paterva.maltego.util.ui.wizard.WizardSegmentFactory;
import com.paterva.maltego.welcome.impl.OptionalPanelsWizardIterator;
import com.paterva.maltego.welcome.impl.WizardSegmentComparator;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public class DefaultLicenseWizardDisplayer
extends LicenseWizardDisplayer {
    public static final String SHOW_RESIZE_FONT_DIALOG = "show.resize.font.dialog";
    private static final String LICENSE_WIZARD_TASK = "LicenseWizardTask";

    public void run() {
        List segments = Lookup.getDefault().lookupAll(WizardSegmentFactory.class).stream().map(factory -> factory.createSegment()).filter(Objects::nonNull).sorted(new WizardSegmentComparator()).collect(Collectors.toList());
        if (!segments.isEmpty()) {
            boolean shouldRestartMaltego = this.increaseDefaultFontSizes();
            if (shouldRestartMaltego) {
                SwingUtilities.invokeLater(() -> {
                    LifecycleManager lifeCycleManager = LifecycleManager.getDefault();
                    lifeCycleManager.markForRestart();
                    lifeCycleManager.exit();
                });
            } else {
                UIRunQueue.instance().queue(0, "Configure Maltego - Startup wizard", () -> {
                    UIRunQueue.instance().registerAsyncTask(LICENSE_WIZARD_TASK);
                    OptionalPanelsWizardIterator it = new OptionalPanelsWizardIterator(segments);
                    WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)it);
                    it.initialize(wizardDescriptor);
                    wizardDescriptor.setTitle("Configure Maltego");
                    wizardDescriptor.setTitleFormat(new MessageFormat("Startup wizard - {0} ({1})"));
                    wizardDescriptor.putProperty("WizardPanel_helpDisplayed", (Object)Boolean.FALSE);
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)wizardDescriptor) == WizardDescriptor.FINISH_OPTION) {
                        segments.forEach(segment -> segment.handleFinish(wizardDescriptor));
                    } else {
                        segments.forEach(segment -> segment.handleCancel(wizardDescriptor));
                    }
                    UIRunQueue.instance().setAsyncTaskCompleted(LICENSE_WIZARD_TASK);
                });
            }
        }
    }

    private boolean increaseDefaultFontSizes() {
        boolean shouldRestartMaltego = false;
        Preferences pref = NbPreferences.forModule(LicenseWizardDisplayer.class);
        if (pref.getBoolean(SHOW_RESIZE_FONT_DIALOG, true)) {
            GraphicsDevice[] screenDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            int maxWidth = -1;
            int maxHeight = -1;
            for (GraphicsDevice screenDevice : screenDevices) {
                Rectangle bounds = screenDevice.getDefaultConfiguration().getBounds();
                if (bounds.width <= maxWidth) continue;
                maxWidth = bounds.width;
                maxHeight = bounds.height;
            }
            if (maxWidth > 1919) {
                FontSizeRegistry fontSizeRegistry;
                int globalFontSizeFromPrefs;
                int globalFontSize;
                int increaseAmount = (int)Math.ceil((double)(maxWidth / 1920 - 1) * 3.8);
                int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
                float multiplier = (float)dpi / 96.0f;
                if ((increaseAmount >= 1 || (double)multiplier > 1.1) && (globalFontSize = OtherComponentsFontSize.DEFAULT) == (globalFontSizeFromPrefs = (fontSizeRegistry = FontSizeRegistry.getDefault()).getFontSize("otherComponentsFontSize"))) {
                    if (SystemInfo.isWindows && screenDevices.length == 1) {
                        increaseAmount = (int)((float)globalFontSize * multiplier) - globalFontSize;
                    }
                    if (increaseAmount >= 1) {
                        int globalNewFontSize = globalFontSize + increaseAmount;
                        UIDefaults laf = UIManager.getLookAndFeelDefaults();
                        String[] notifyFontKeys = new String[]{"OptionPane.messageFont", "Button.font"};
                        HashMap<String, Font> notifyFonts = new HashMap<String, Font>();
                        for (String notifyFontKey : notifyFontKeys) {
                            Font notifyFont = laf.getFont(notifyFontKey);
                            if (notifyFont == null) continue;
                            notifyFonts.put(notifyFontKey, notifyFont);
                            laf.put(notifyFontKey, notifyFont.deriveFont((float)globalNewFontSize));
                        }
                        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)String.format("The maximum screen resolution of the attached monitors has been detected as %d x %d pixels. It is recommended that the default font sizes be increased from %d to %d. The size of this text is %d. This can later be changed at the \"Display\" section of the \"Options\" dialog. Do you want to make this change (Maltego will automatically restart)?", maxWidth, maxHeight, globalFontSize, globalNewFontSize, globalNewFontSize), "Change Default Font Sizes");
                        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) == NotifyDescriptor.YES_OPTION) {
                            List fontSizes = fontSizeRegistry.getAll();
                            for (FontSizeDescriptor fontSize : fontSizes) {
                                int localMaxFontSize;
                                int localNewFontSize = fontSize.getDefaultFontSize() + increaseAmount;
                                localNewFontSize = localNewFontSize > (localMaxFontSize = fontSize.getMaxFontSize()) ? localMaxFontSize : localNewFontSize;
                                fontSizeRegistry.setFontSize(fontSize.getName(), localNewFontSize);
                            }
                            shouldRestartMaltego = true;
                        } else {
                            for (Map.Entry entrySet : notifyFonts.entrySet()) {
                                String key = (String)entrySet.getKey();
                                Font value = (Font)entrySet.getValue();
                                laf.put(key, value);
                            }
                        }
                        pref.putBoolean(SHOW_RESIZE_FONT_DIALOG, false);
                    }
                }
            }
        }
        return shouldRestartMaltego;
    }
}

