/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.math.DD;

public class CGAlgorithmsDD {
    private static final double DP_SAFE_EPSILON = 1.0E-15;

    public static int orientationIndex(Coordinate p1, Coordinate p2, Coordinate q) {
        int index = CGAlgorithmsDD.orientationIndexFilter(p1, p2, q);
        if (index <= 1) {
            return index;
        }
        DD dx1 = DD.valueOf(p2.x).selfAdd(-p1.x);
        DD dy1 = DD.valueOf(p2.y).selfAdd(-p1.y);
        DD dx2 = DD.valueOf(q.x).selfAdd(-p2.x);
        DD dy2 = DD.valueOf(q.y).selfAdd(-p2.y);
        return dx1.selfMultiply(dy2).selfSubtract(dy1.selfMultiply(dx2)).signum();
    }

    public static int signOfDet2x2(DD x1, DD y1, DD x2, DD y2) {
        DD det = x1.multiply(y2).selfSubtract(y1.multiply(x2));
        return det.signum();
    }

    private static int orientationIndexFilter(Coordinate pa, Coordinate pb, Coordinate pc) {
        double detsum;
        double detleft = (pa.x - pc.x) * (pb.y - pc.y);
        double detright = (pa.y - pc.y) * (pb.x - pc.x);
        double det = detleft - detright;
        if (detleft > 0.0) {
            if (detright <= 0.0) {
                return CGAlgorithmsDD.signum(det);
            }
            detsum = detleft + detright;
        } else if (detleft < 0.0) {
            if (detright >= 0.0) {
                return CGAlgorithmsDD.signum(det);
            }
            detsum = -detleft - detright;
        } else {
            return CGAlgorithmsDD.signum(det);
        }
        double errbound = 1.0E-15 * detsum;
        if (det >= errbound || -det >= errbound) {
            return CGAlgorithmsDD.signum(det);
        }
        return 2;
    }

    private static int signum(double x) {
        if (x > 0.0) {
            return 1;
        }
        if (x < 0.0) {
            return -1;
        }
        return 0;
    }

    public static Coordinate intersection(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        DD denom1 = DD.valueOf(q2.y).selfSubtract(q1.y).selfMultiply(DD.valueOf(p2.x).selfSubtract(p1.x));
        DD denom2 = DD.valueOf(q2.x).selfSubtract(q1.x).selfMultiply(DD.valueOf(p2.y).selfSubtract(p1.y));
        DD denom = denom1.subtract(denom2);
        DD numx1 = DD.valueOf(q2.x).selfSubtract(q1.x).selfMultiply(DD.valueOf(p1.y).selfSubtract(q1.y));
        DD numx2 = DD.valueOf(q2.y).selfSubtract(q1.y).selfMultiply(DD.valueOf(p1.x).selfSubtract(q1.x));
        DD numx = numx1.subtract(numx2);
        double fracP = numx.selfDivide(denom).doubleValue();
        double x = DD.valueOf(p1.x).selfAdd(DD.valueOf(p2.x).selfSubtract(p1.x).selfMultiply(fracP)).doubleValue();
        DD numy1 = DD.valueOf(p2.x).selfSubtract(p1.x).selfMultiply(DD.valueOf(p1.y).selfSubtract(q1.y));
        DD numy2 = DD.valueOf(p2.y).selfSubtract(p1.y).selfMultiply(DD.valueOf(p1.x).selfSubtract(q1.x));
        DD numy = numy1.subtract(numy2);
        double fracQ = numy.selfDivide(denom).doubleValue();
        double y = DD.valueOf(p1.y).selfAdd(DD.valueOf(p2.y).selfSubtract(p1.y).selfMultiply(fracQ)).doubleValue();
        return new Coordinate(x, y);
    }
}

