/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.isg.pyramidio;

import gov.nist.isg.pyramidio.ImageInfo;
import gov.nist.isg.pyramidio.PartialImageReader;
import gov.nist.isg.pyramidio.ProgressCallback;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public final class BufferedImageReader
implements PartialImageReader {
    private static final int START = 1;
    private static final int BUFFERING = 15;
    private final ProgressCallback progressCb;
    private final boolean printDebug;
    private final int maxLength;
    private final boolean sections;
    private BufferedImage image;
    private BufferedImage[][] imageSections;
    private int width;
    private int height;

    public BufferedImageReader(File imageFile, int tileSize, boolean readInSections, ProgressCallback cb, boolean debug) throws IOException {
        this.progressCb = cb;
        this.progressCb.update("DZI_IMAGE", "Buffering image for tile viewer", 1);
        this.printDebug = debug;
        this.maxLength = 16000 / tileSize * tileSize;
        if (readInSections) {
            this.sections = true;
            Dimension dim = this.getImageDimension(imageFile);
            this.createImageSections(imageFile, dim);
            this.width = dim.width;
            this.height = dim.height;
        } else {
            this.sections = false;
            this.image = ImageIO.read(imageFile);
            if (this.image == null) {
                throw new IOException("No codec found for image " + imageFile);
            }
        }
        this.progressCb.update("DZI_IMAGE", "Done buffering image for tile viewer", 15);
    }

    @Override
    public BufferedImage read(Rectangle rectangle) throws IOException {
        BufferedImage subimage;
        if (this.sections) {
            int col = rectangle.x / this.maxLength;
            int row = rectangle.y / this.maxLength;
            int x = rectangle.x - col * this.maxLength;
            int y = rectangle.y - row * this.maxLength;
            subimage = this.imageSections[row][col].getSubimage(x, y, rectangle.width, rectangle.height);
            if (this.printDebug) {
                System.out.println("row = " + row + "; col = " + col);
            }
            this.progressCb.update("DZI_IMAGE", "Writing tiles for viewer", 84 * (row + 1) * (col + 1) / (this.imageSections.length * this.imageSections[0].length) + 15);
        } else {
            subimage = this.image.getSubimage(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        BufferedImage newSubImage = new BufferedImage(subimage.getWidth(), subimage.getHeight(), 1);
        Graphics2D g = newSubImage.createGraphics();
        g.drawImage(subimage, 0, 0, Color.WHITE, null);
        g.dispose();
        return newSubImage;
    }

    @Override
    public int getWidth() {
        return this.sections ? this.width : this.image.getWidth();
    }

    @Override
    public int getHeight() {
        return this.sections ? this.height : this.image.getHeight();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Dimension getImageDimension(File resourceFile) {
        try (ImageInputStream in = ImageIO.createImageInputStream(resourceFile);){
            ImageInfo imageInfo = new ImageInfo();
            imageInfo.setInput(in);
            imageInfo.check();
            Dimension dimension = new Dimension(imageInfo.getWidth(), imageInfo.getHeight());
            return dimension;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void createImageSections(File imageFile, Dimension dim) throws IOException {
        int imgWidth = dim.width;
        int imgHeight = dim.height;
        if (this.printDebug) {
            System.out.println("Image dimensions: width = " + imgWidth + ", height = " + imgHeight);
        }
        int sectionsX = (int)Math.ceil((double)imgWidth / (double)this.maxLength);
        int sectionsY = (int)Math.ceil((double)imgHeight / (double)this.maxLength);
        this.imageSections = new BufferedImage[sectionsY][sectionsX];
        for (int row = 0; row < sectionsY; ++row) {
            for (int col = 0; col < sectionsX; ++col) {
                ImageInputStream input = ImageIO.createImageInputStream(imageFile);
                Iterator<ImageReader> readers = ImageIO.getImageReaders(input);
                ImageReader reader = BufferedImageReader.getReader(readers, true);
                if (this.printDebug) {
                    System.out.println(reader.toString().toLowerCase());
                }
                reader.setInput(input);
                ImageReadParam param = reader.getDefaultReadParam();
                Rectangle rect = new Rectangle(col * this.maxLength, row * this.maxLength, Math.min(this.maxLength, imgWidth - col * this.maxLength), Math.min(this.maxLength, imgHeight - row * this.maxLength));
                if (this.printDebug) {
                    System.out.println(rect);
                }
                param.setSourceRegion(rect);
                this.imageSections[row][col] = reader.read(0, param);
                this.progressCb.update("DZI_IMAGE", "Buffering image for tile viewer", 14 * (row + 1) * (col + 1) / (sectionsX * sectionsY) + 1);
            }
        }
    }

    private static ImageReader getReader(Iterator<ImageReader> readers, boolean throwException) throws IOException {
        if (!readers.hasNext()) {
            if (throwException) {
                throw new IOException("No reader available for supplied image stream.");
            }
            return null;
        }
        ImageReader reader = readers.next();
        String readerString = reader.toString().toLowerCase();
        if (readerString.contains("bmp") && !readerString.contains("com.sun.imageio.plugins.bmp.bmpimagereader")) {
            reader = BufferedImageReader.getReader(readers, throwException);
        }
        return reader;
    }
}

