/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.ui.hub;

import com.paterva.maltego.seeds.api.HubSeedTag;
import com.paterva.maltego.seeds.ui.HubFilterManager;
import com.paterva.maltego.seeds.ui.hub.HubItemsPanel;
import com.paterva.maltego.seeds.ui.hub.SeedItemDescriptor;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class HubPartnersPanel
extends HubItemsPanel {
    private static final String PREF_EXPANDED = "maltego.hub.partners.expanded";

    public HubPartnersPanel() {
        super("MALTEGO DATA HUB PARTNERS", PREF_EXPANDED);
        this.setBackgroundColor(MaltegoLAF.getLookAndFeelDefaults().getColor("hub-partners-bg"));
    }

    @Override
    protected boolean filter(SeedItemDescriptor item, boolean tagFilter) {
        if (item.getSeed().isCustom()) {
            return false;
        }
        if (tagFilter) {
            HubFilterManager filterManager = HubFilterManager.getInstance();
            if (!filterManager.anySelected()) {
                return true;
            }
            List itemTags = item.getSeed().getTags();
            Map<String, List<HubSeedTag>> selected = filterManager.getSelectedMap();
            for (Map.Entry<String, List<HubSeedTag>> entry : selected.entrySet()) {
                String tagType = entry.getKey();
                List itemTagsOfType = itemTags.stream().filter(tag -> Objects.equals(tagType, tag.getType())).collect(Collectors.toList());
                ArrayList tags = new ArrayList(entry.getValue());
                tags.retainAll(itemTagsOfType);
                if (!tags.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }
}

