/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.ui.auth;

import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.seeds.api.registry.HubSeedSettings;
import com.paterva.maltego.seeds.ui.auth.HubSeedAuthenticationPanel;
import com.paterva.maltego.seeds.ui.auth.HubSeedsAuthenticationPanel;
import com.paterva.maltego.transform.api.TransformMessage;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.runner.TransformMessageWindow;
import com.paterva.maltego.transform.runner.api.TransformErrorHandler;
import com.paterva.maltego.transform.runner.api.TransformRunContext;
import com.paterva.maltego.transform.runner.api.TransformsRunContext;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.util.Args;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;

public class HubSeedAuthErrorHandler
implements TransformErrorHandler {
    private static boolean _isHandlingError = false;

    public boolean handle(TransformRunContext ctx, TransformMessage message) {
        Args.notNull((Object)ctx, (String)"ctx");
        Args.notNull((Object)message, (String)"message");
        TransformsRunContext transformsContext = ctx.getTransformsContext();
        if (message.getCode() == 600 || message.getCode() == 401) {
            if (transformsContext.isPopupErrors()) {
                SwingUtilities.invokeLater(() -> this.showMissingApiKeyDialog(ctx));
            }
            TransformMessageWindow.getDefault().write(message);
            return true;
        }
        return false;
    }

    private void showMissingApiKeyDialog(TransformRunContext ctx) {
        NotifyDescriptor.Message nd;
        String msg;
        if (_isHandlingError) {
            return;
        }
        _isHandlingError = true;
        TransformServerInfo server = ctx.getServer().orElse(null);
        if (server == null) {
            return;
        }
        TransformDefinition transform = ctx.getTransform();
        List hubSeeds = HubSeedRegistry.getDefault().getHubSeeds(server);
        HashMap<HubSeedDescriptor, DisplayDescriptorCollection> authProps = new HashMap<HubSeedDescriptor, DisplayDescriptorCollection>();
        for (HubSeedDescriptor hubSeed : hubSeeds) {
            DisplayDescriptorCollection props = HubSeedSettings.getDefault().getGlobalTransformProperties(hubSeed, transform, true);
            if (props.isEmpty()) continue;
            authProps.put(hubSeed, props);
        }
        String title = "Transform Authentication";
        if (authProps.isEmpty()) {
            msg = "The following Transform requires authentication:\n\n   " + transform.getDisplayName() + "\n\nBut no Maltego Data Hub authentication settings exist for it.";
            nd = new NotifyDescriptor.Message((Object)msg);
            nd.setTitle(title);
            nd.setMessageType(2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        } else {
            msg = "The following Transform requires authentication:\n\n   " + transform.getDisplayName() + "\n\nThe authentication settings have either not been entered or is invalid.\n\nDo you want to open the authentication settings?";
            nd = new NotifyDescriptor.Confirmation((Object)msg);
            nd.setTitle(title);
            nd.setOptionType(0);
            if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd))) {
                JPanel panel;
                if (authProps.size() > 1) {
                    panel = new HubSeedsAuthenticationPanel(authProps);
                } else {
                    Map.Entry entry = authProps.entrySet().iterator().next();
                    panel = new HubSeedAuthenticationPanel((HubSeedDescriptor)entry.getKey(), (DisplayDescriptorCollection)entry.getValue());
                }
                JButton closeButton = new JButton("Close");
                DialogDescriptor dd = new DialogDescriptor((Object)panel, title, true, (Object[])new JButton[]{closeButton}, (Object)closeButton, 0, HelpCtx.DEFAULT_HELP, null);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            }
        }
        _isHandlingError = false;
    }
}

