/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.table;

import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class PaddedTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private final Border _normalBorder;
    private final boolean _centerInts;

    public PaddedTableCellRenderer() {
        this(true);
    }

    public PaddedTableCellRenderer(boolean centerInts) {
        this._centerInts = centerInts;
        this._normalBorder = BorderFactory.createEmptyBorder(2, 5, 2, 2);
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        this.setFont(table.getFont());
        this.setBorder(this._normalBorder);
        if (this._centerInts && PaddedTableCellRenderer.isInteger(value)) {
            this.setHorizontalAlignment(0);
        } else {
            this.setHorizontalAlignment(2);
        }
        this.setText(value == null ? "" : value.toString());
        return this;
    }

    private static boolean isInteger(Object object) {
        boolean isInteger;
        if (object instanceof Integer) {
            isInteger = true;
        } else {
            try {
                Integer.parseInt(object.toString());
                isInteger = true;
            }
            catch (Exception ex) {
                isInteger = false;
            }
        }
        return isInteger;
    }
}

