/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.image;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import org.openide.util.ImageUtilities;

public class ImageStripNavButton
extends JButton {
    private final Image _imageNormal;
    private final Image _imageHovered;
    private final Image _imageDisabled;
    private boolean _hovered = false;

    public ImageStripNavButton(boolean left) {
        String dir = left ? "left" : "right";
        this._imageNormal = ImageUtilities.loadImage((String)("com/paterva/maltego/util/ui/image/" + dir + "_normal.png"));
        this._imageHovered = ImageUtilities.loadImage((String)("com/paterva/maltego/util/ui/image/" + dir + "_hover.png"));
        this._imageDisabled = ImageUtilities.loadImage((String)("com/paterva/maltego/util/ui/image/" + dir + "_disabled.png"));
        Dimension dim = new Dimension(50, 50);
        this.setPreferredSize(dim);
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
        this.setOpaque(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ImageStripNavButton.this._hovered = true;
                ImageStripNavButton.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ImageStripNavButton.this._hovered = false;
                ImageStripNavButton.this.repaint();
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        int x = this.getPreferredSize().width;
        int y = this.getPreferredSize().height;
        if (!this.isEnabled()) {
            g.drawImage(this._imageDisabled, (x - this._imageDisabled.getWidth(this)) / 2, (y - this._imageDisabled.getHeight(this)) / 2, null);
        } else if (this._hovered) {
            g.drawImage(this._imageHovered, (x - this._imageHovered.getWidth(this)) / 2, (y - this._imageHovered.getHeight(this)) / 2, null);
        } else {
            g.drawImage(this._imageNormal, (x - this._imageNormal.getWidth(this)) / 2, (y - this._imageNormal.getHeight(this)) / 2, null);
        }
    }
}

