/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.dialog;

import com.paterva.maltego.util.ui.dialog.ValidatingController;
import com.paterva.maltego.util.ui.dialog.WizardNavigationSupport;
import java.util.ArrayList;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.util.ChangeSupport;

public class ArrayWizardIterator<Data>
implements WizardDescriptor.Iterator<Data> {
    private final WizardDescriptor.Panel<Data>[] _panels;
    private int _index = 0;
    private final ChangeSupport _changeSupport = new ChangeSupport((Object)this);

    public ArrayWizardIterator(WizardDescriptor.Panel<Data>[] panels) {
        this._panels = panels;
        for (WizardDescriptor.Panel<Data> p : panels) {
            if (!(p instanceof ValidatingController)) continue;
            ValidatingController vd = (ValidatingController)p;
            vd.putClientProperty("maltego.navigation.changesupport", this._changeSupport);
        }
    }

    public WizardDescriptor.Panel<Data> current() {
        return this._panels[this._index];
    }

    public String name() {
        return String.format("%d of %d", this._index + 1, this._panels.length);
    }

    public boolean hasNext() {
        return this._index < this._panels.length - 1;
    }

    public boolean hasPrevious() {
        if (this._index > 0) {
            WizardDescriptor.Panel<Data> current = this.current();
            if (current instanceof WizardNavigationSupport) {
                WizardNavigationSupport support = (WizardNavigationSupport)current;
                return support.canBack();
            }
            return true;
        }
        return false;
    }

    public void nextPanel() {
        ++this._index;
    }

    public void previousPanel() {
        --this._index;
    }

    protected void fireChange() {
        this._changeSupport.fireChange();
    }

    public String[] getContentPaneData() {
        ArrayList<String> steps = new ArrayList<String>();
        for (WizardDescriptor.Panel<Data> panel : this._panels) {
            steps.add(panel.getComponent().getName());
        }
        return steps.toArray(new String[steps.size()]);
    }

    public void addChangeListener(ChangeListener cl) {
        this._changeSupport.addChangeListener(cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        if (this._changeSupport != null) {
            this._changeSupport.removeChangeListener(cl);
        }
    }
}

