/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.ctxmenu;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class MousePositionLayout
implements LayoutManager {
    private static final int TIMER_FAST_DELAY = 8;
    private static final double PERCENT_PER_SECOND = 0.5;
    private static final int MAX_PIXELS_PER_UPDATE = 3;
    private final int _vgap;
    private final int _minWidth;
    private Timer _timer;
    private long _lastUpdate = 0L;
    private Double _firstXLocation = null;

    public MousePositionLayout(int vgap, int minWidth) {
        this._vgap = vgap;
        this._minWidth = minWidth;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.minimumLayoutSize(parent);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        int height = 0;
        for (Component component : parent.getComponents()) {
            height = Math.max(height, component.getPreferredSize().height);
        }
        return new Dimension(this._minWidth, height);
    }

    @Override
    public void layoutContainer(final Container parent) {
        if (this._timer == null) {
            this._lastUpdate = System.currentTimeMillis();
            this._firstXLocation = null;
            this.layout(parent, true);
            this._timer = new Timer(8, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MousePositionLayout.this.layout(parent, false);
                }
            });
            this._timer.setRepeats(true);
            this._timer.start();
        }
    }

    private void layout(Container parent, boolean force) {
        int totalShift;
        if (!(force || parent.isVisible() && parent.getParent() != null && parent.isShowing())) {
            this.stop();
            return;
        }
        Component[] components = parent.getComponents();
        int virtualWidth = this.getTotalWidth(components);
        int marginWest = MousePositionLayout.getWidth(components[0]);
        int marginEast = MousePositionLayout.getWidth(components[components.length - 1]);
        if (virtualWidth < parent.getWidth()) {
            boolean center = false;
            totalShift = 0;
        } else {
            int actualWidth = parent.getWidth() - (marginWest + marginEast);
            int mouseX = this.getMouseXBetweenMiddleOfFirstAndLastComponents(parent, marginWest, actualWidth);
            double fraction = (double)mouseX / (double)actualWidth;
            totalShift = (int)(-((double)(virtualWidth - parent.getWidth()) * fraction));
        }
        int x = 0;
        Integer actualShift = null;
        long time = System.currentTimeMillis();
        long elapsed = time - this._lastUpdate;
        if (elapsed == 0L) {
            elapsed = 1L;
        }
        for (Component component : components) {
            Point location = component.getLocation();
            if (this._firstXLocation == null) {
                this._firstXLocation = location.getX();
            }
            if (actualShift == null) {
                double distance = (double)totalShift - this._firstXLocation;
                if (Math.abs(distance) < 1.0) {
                    actualShift = totalShift;
                    this.stop();
                } else {
                    double shift = distance * 0.5 / (double)elapsed;
                    shift = Math.copySign(Math.min(Math.abs(shift), 3.0), shift);
                    this._firstXLocation = this._firstXLocation + shift;
                    actualShift = this._firstXLocation.intValue();
                }
            }
            Dimension size = component.getPreferredSize();
            component.setLocation(x + actualShift, 0);
            component.setSize(size);
            x += size.width + this._vgap;
        }
        this._lastUpdate = time;
    }

    private void stop() {
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
        }
    }

    private int getMouseXBetweenMiddleOfFirstAndLastComponents(Container parent, int marginWest, int actualWidth) {
        int mouseX = this.getMouseX(parent);
        if ((mouseX -= marginWest) < 0) {
            mouseX = 0;
        } else if (mouseX > actualWidth) {
            mouseX = actualWidth;
        }
        return mouseX;
    }

    private int getTotalWidth(Component[] components) {
        int virtualWidth = 0;
        for (Component component : components) {
            virtualWidth += MousePositionLayout.getWidth(component) + this._vgap;
        }
        return virtualWidth -= this._vgap;
    }

    private static int getWidth(Component component) {
        return component.getPreferredSize().width;
    }

    private int getMouseX(Container parent) throws HeadlessException {
        if (!parent.isShowing()) {
            return 0;
        }
        boolean snapback = true;
        Point mousePos = parent.getMousePosition();
        return mousePos == null ? 0 : mousePos.x;
    }
}

