/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import javax.swing.UIManager;

public class ComponentFlasher
implements ActionListener {
    private final Timer _timer;
    private final Component _component;
    private final Color _origColor;
    private final Color _flashColor;
    private final int _count;
    private int _flashed = 0;

    public static void flash(Component c) {
        ComponentFlasher.flash(c, UIManager.getLookAndFeelDefaults().getColor("component-flasher-background-color"));
    }

    public static void flash(Component c, Color flashColor) {
        ComponentFlasher.flash(c, flashColor, 350, 4);
    }

    public static void flash(Component c, Color flashColor, int delay, int count) {
        Timer timer = new Timer(delay, null);
        timer.addActionListener(new ComponentFlasher(timer, c, flashColor, count));
        timer.setRepeats(true);
        timer.start();
    }

    private ComponentFlasher(Timer timer, Component c, Color flashColor, int count) {
        this._timer = timer;
        this._component = c;
        this._origColor = c.getBackground();
        this._flashColor = flashColor;
        this._count = count;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this._flashed < this._count * 2) {
            this._component.setBackground(this._flashed % 2 != 0 ? this._origColor : this._flashColor);
        } else {
            this._component.setBackground(this._origColor);
            this._timer.stop();
        }
        ++this._flashed;
    }
}

