/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.maltego.cloud.data.KeyDerivation;
import com.maltego.cloud.data.SymmetricEncryptionConfig;
import java.util.Objects;
import java.util.UUID;

@JsonIgnoreProperties(ignoreUnknown=true)
public class KeyPair {
    private final UUID id;
    private final UUID userId;
    private final String format;
    private final KeyDerivation passwordKeyDerivationConfig;
    private final SymmetricEncryptionConfig privateKeyEncryptionConfig;
    private final String publicKey;
    private final String encryptedPrivateKey;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public KeyPair(@JsonProperty(value="id", required=true) UUID id, @JsonProperty(value="userId") UUID userId, @JsonProperty(value="format", required=true) String format, @JsonProperty(value="passwordKeyDerivationConfig", required=true) KeyDerivation passwordKeyDerivationConfig, @JsonProperty(value="privateKeyEncryptionConfig", required=true) SymmetricEncryptionConfig privateKeyEncryptionConfig, @JsonProperty(value="publicKey", required=true) String publicKey, @JsonProperty(value="encryptedPrivateKey", required=true) String encryptedPrivateKey) {
        this.id = id;
        this.userId = userId;
        this.format = format;
        this.passwordKeyDerivationConfig = passwordKeyDerivationConfig;
        this.privateKeyEncryptionConfig = privateKeyEncryptionConfig;
        this.publicKey = publicKey;
        this.encryptedPrivateKey = encryptedPrivateKey;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getUserId() {
        return this.userId;
    }

    public String getFormat() {
        return this.format;
    }

    public KeyDerivation getPasswordKeyDerivationConfig() {
        return this.passwordKeyDerivationConfig;
    }

    public SymmetricEncryptionConfig getPrivateKeyEncryptionConfig() {
        return this.privateKeyEncryptionConfig;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getEncryptedPrivateKey() {
        return this.encryptedPrivateKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyPair)) {
            return false;
        }
        KeyPair keyPair = (KeyPair)o;
        return Objects.equals(this.id, keyPair.id) && Objects.equals(this.userId, keyPair.userId) && Objects.equals(this.format, keyPair.format) && Objects.equals(this.passwordKeyDerivationConfig, keyPair.passwordKeyDerivationConfig) && Objects.equals(this.privateKeyEncryptionConfig, keyPair.privateKeyEncryptionConfig) && Objects.equals(this.publicKey, keyPair.publicKey) && Objects.equals(this.encryptedPrivateKey, keyPair.encryptedPrivateKey);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.userId, this.format, this.passwordKeyDerivationConfig, this.privateKeyEncryptionConfig, this.publicKey, this.encryptedPrivateKey);
    }

    public String toString() {
        return "KeyPair{id=" + this.id + ", userId=" + this.userId + ", format=" + this.format + ", passwordKeyDerivationConfig=" + this.passwordKeyDerivationConfig + ", privateKeyEncryptionConfig=" + this.privateKeyEncryptionConfig + ", publicKey=" + this.publicKey + ", encryptedPrivateKey=" + this.encryptedPrivateKey + '}';
    }
}

