/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.transforms;

import com.paterva.maltego.typing.serializer.AttachmentsPathRegistry;
import com.paterva.maltego.typing.types.InternalFile;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simpleframework.xml.transform.Transform;

public class InternalFileTransform
implements Transform<InternalFile> {
    private static final Logger LOG = Logger.getLogger(InternalFileTransform.class.getName());

    public InternalFile read(String value) throws Exception {
        LOG.log(Level.FINE, "Read attachments: {0}", value);
        Map<Integer, String> paths = AttachmentsPathRegistry.getPaths();
        int id = -1;
        if (paths != null) {
            for (Map.Entry<Integer, String> entry : paths.entrySet()) {
                if (!value.equals(entry.getValue())) continue;
                id = entry.getKey();
                break;
            }
        }
        return id < 0 ? null : new InternalFile(id);
    }

    public String write(InternalFile value) throws Exception {
        String text = AttachmentsPathRegistry.getPaths().get(value.fileStoreIndex);
        LOG.log(Level.FINE, "Write attachments: {0}", text);
        return text;
    }
}

