/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.wizard;

import com.paterva.maltego.graph.table.ui.wizard.ImportTutorialPanel;
import com.paterva.maltego.util.ui.HtmlUIUtils;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.io.IOException;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbPreferences;

public class ImportTutorialController
extends ValidatingController<ImportTutorialPanel> {
    private String _htmlTutorial;
    private static final String IMAGE_BASE_URL = "/com/paterva/maltego/graph/table/ui/tutorial/";
    private static final String[] IMAGES = new String[]{"ChooseMappingBase.png", "ConnectivityOptions.png", "ConnectivityTable.png", "DefaultConnectivityBase.png", "EditPropertyBase.png", "MappingConfigurationBase.png", "MappingManagerEditDelete.png", "WizzardLinkMappingBase.png", "WizzardSettingsBase.png", "WizzardSummaryBase.png"};
    private static final String[] LAF_COLORS = new String[]{"tabular-import-tutorial-body-background-color", "tabular-import-tutorial-body-color", "tabular-import-tutorial-h1-color", "tabular-import-tutorial-h1-border-bottom", "tabular-import-tutorial-h2-color", "tabular-import-tutorial-h3-color", "tabular-import-tutorial-p-asside-background-color", "tabular-import-tutorial-p-asside-border", "tabular-import-tutorial-toc-text", "tabular-import-tutorial-img-centered-border"};

    public ImportTutorialController() {
        this.setName("Tutorial");
        this.setDescription("Read through the tutorial to understand the steps involved in importing a graph from a table structured file.");
        this.setImage(ImageUtilities.loadImage((String)"com/paterva/maltego/graph/table/ui/resources/ImportTabularGraph.png".replace(".png", "48.png")));
    }

    public boolean mustShow() {
        return true;
    }

    protected ImportTutorialPanel createComponent() {
        return new ImportTutorialPanel(this.htmlTutorial());
    }

    private String htmlTutorial() {
        if (this._htmlTutorial == null) {
            try {
                this._htmlTutorial = HtmlUIUtils.appendStyleSheet((String)HtmlUIUtils.substituteImageURLs((String)HtmlUIUtils.loadFromFile((String)"Maltego/GraphTableUI/HTMLImportTutorial"), ImportTutorialController.class, (String)IMAGE_BASE_URL, (String[])IMAGES), (String)"Maltego/GraphTableUI/HTMLImportTutorialStyle", (String[])LAF_COLORS);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this._htmlTutorial;
    }

    protected void readSettings(WizardDescriptor settings) {
    }

    protected void storeSettings(WizardDescriptor settings) {
        if (settings.getValue() == WizardDescriptor.CANCEL_OPTION) {
            return;
        }
        if (((ImportTutorialPanel)this.component()).showTutorialAgain()) {
            NbPreferences.forModule(ImportTutorialController.class).putBoolean("showImportTutorial", true);
        } else {
            NbPreferences.forModule(ImportTutorialController.class).putBoolean("showImportTutorial", false);
        }
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }
}

