/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf.ribbon;

import com.paterva.maltego.util.IconSize;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;

public class CollapsedBandIcon
implements ResizableIcon {
    protected static final int SIZE = 31;
    protected static final int MAX_ICONSIZE = 20;
    protected static final int CORNER_SIZE = 3;
    protected static final int BAR_HEIGHT = 7;
    protected static final Insets INSETS = new Insets(3, 3, 0, 3);
    protected static final Color BORDER_COLOR = new Color(0xA0A0A0);
    protected static final Color BAR_COLOR = new Color(0xC2C2C2);
    protected Icon inner;

    public CollapsedBandIcon() {
        this(null);
    }

    public CollapsedBandIcon(Icon icon) {
        if (icon == null) {
            icon = new ImageIcon();
        } else if (icon.getIconHeight() > 20 || icon.getIconWidth() > 20) {
            if (icon instanceof ResizableIcon) {
                ResizableIcon ri = (ResizableIcon)icon;
                int iconSize = IconSize.TINY.getSize();
                ri.setDimension(new Dimension(iconSize, iconSize));
            } else {
                throw new IllegalArgumentException("icon exceeds the max size (20)");
            }
        }
        this.inner = icon;
    }

    public int getIconHeight() {
        return 31 + CollapsedBandIcon.INSETS.top + CollapsedBandIcon.INSETS.bottom;
    }

    public int getIconWidth() {
        return 31 + CollapsedBandIcon.INSETS.left + CollapsedBandIcon.INSETS.right;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int x1 = (x += CollapsedBandIcon.INSETS.left) + 3;
        int x2 = x + 31 - 3 - 1;
        int x3 = x + 31 - 1;
        int y1 = (y += CollapsedBandIcon.INSETS.top) + 3;
        int y2 = y + 31 - 3 - 1;
        int y3 = y + 31 - 1;
        Composite old = g2d.getComposite();
        g2d.setComposite(AlphaComposite.getInstance(3, 0.5f));
        g2d.setColor(Color.WHITE);
        for (int i = 1; i < 3; ++i) {
            g2d.drawLine(x + i + 1, y + 3 - i, x3 - i - 1, y + 3 - i);
        }
        g2d.drawLine(x + 1, y1 - 1, x1, y);
        g2d.drawLine(x2, y, x3 - 1, y1 - 1);
        g2d.fillRect(x + 1, y1, 29, 20);
        g2d.setComposite(old);
        g2d.setColor(BAR_COLOR);
        g2d.fillRect(x + 1, y + 31 - 7 - 1, 29, 7);
        g2d.setColor(BORDER_COLOR);
        g2d.drawLine(x, y1 - 1, x1 - 1, y);
        g2d.drawLine(x1, y, x2, y);
        g2d.drawLine(x2 + 1, y, x3, y1 - 1);
        g2d.drawLine(x3, y1, x3, y2);
        g2d.drawLine(x3, y2 + 1, x2 + 1, y3);
        g2d.drawLine(x1, y3, x2, y3);
        g2d.drawLine(x1 - 1, y3, x, y2 + 1);
        g2d.drawLine(x, y1, x, y2);
        g2d.dispose();
        x1 = x + (31 - this.inner.getIconWidth()) / 2;
        y1 = y + (24 - this.inner.getIconHeight()) / 2;
        this.inner.paintIcon(c, g, x1, y1);
    }

    public void setDimension(Dimension newDimension) {
    }
}

