/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v3.prompts.choice.controls;

import com.maltego.tx3.java.api.execution.CheckboxChoicePromptControl;
import com.maltego.tx3.java.api.execution.ChoicePrompt;
import com.maltego.tx3.java.api.execution.TransformRunChoicePromptEvent;
import com.maltego.tx3.java.api.execution.TransformRunPromptResponse;
import com.paterva.maltego.transform.protocol.v3.prompts.choice.controls.PromptControl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class CheckboxPromptControl
extends PromptControl {
    private final String controlId;

    public CheckboxPromptControl(String transformName, TransformRunChoicePromptEvent prompt) {
        super(transformName, prompt.getMessage(), prompt.getTimeout());
        Map<String, ChoicePrompt> optionsMap = this.gatherOptions(prompt);
        ArrayList<String> defaultOptionIds = new ArrayList<String>();
        if (prompt.getDefaultOptionId() != null) {
            defaultOptionIds.add(prompt.getDefaultOptionId());
        }
        String id = null;
        String label = null;
        if (prompt.getControl() != null) {
            id = prompt.getControl().getControlId();
            label = prompt.getControl().getLabel();
            CheckboxChoicePromptControl promptControl = (CheckboxChoicePromptControl)prompt.getControl();
            if (promptControl.getDefaultOptionIds() != null) {
                defaultOptionIds.addAll(promptControl.getDefaultOptionIds());
            }
        }
        this.controlId = this.addCheckboxControl(id, label, defaultOptionIds, optionsMap.values().stream().collect(Collectors.toList()));
        this.resize();
    }

    @Override
    public TransformRunPromptResponse handleResponse(Object result) {
        TransformRunPromptResponse.ResponseReason reason = TransformRunPromptResponse.ResponseReason.COMPLETED;
        Map response = new HashMap();
        if (result != null && (reason = this.getReason(result, reason)) != TransformRunPromptResponse.ResponseReason.CANCELLED) {
            response = this.gatherResponses().getOrDefault(this.controlId, new HashMap());
        }
        return new TransformRunPromptResponse(reason, response);
    }
}

