/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.graph.store.pandora.parts;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.store.AbstractBatchUpdatable;
import com.pinkmatter.pandora.PandoraConnection;
import com.pinkmatter.pandora.PandoraStore;
import com.pinkmatter.pandora.lucene.PandoraLuceneFactory;
import java.beans.PropertyChangeSupport;
import org.openide.util.Exceptions;

public abstract class PandoraPartsWriter
extends AbstractBatchUpdatable<Boolean> {
    private final GraphID _id;
    private PandoraStore _entityStore;
    private PandoraStore _linkStore;
    private final PropertyChangeSupport _changeSupport;

    public PandoraPartsWriter(GraphID id, PropertyChangeSupport changeSupport) {
        this._id = id;
        this._changeSupport = changeSupport;
    }

    public GraphID getGraphID() {
        return this._id;
    }

    public PropertyChangeSupport getChangeSupport() {
        return this._changeSupport;
    }

    public PandoraStore getEntityStore() {
        return this._entityStore;
    }

    public PandoraStore getLinkStore() {
        return this._linkStore;
    }

    public void setEntityConnection(PandoraConnection entityConn) {
        if (entityConn == null) {
            this._entityStore = null;
        } else {
            PandoraLuceneFactory factory = new PandoraLuceneFactory();
            this._entityStore = factory.createStore(entityConn, false, false);
        }
    }

    public void setLinkConnection(PandoraConnection linkConn) {
        if (linkConn == null) {
            this._linkStore = null;
        } else {
            PandoraLuceneFactory factory = new PandoraLuceneFactory();
            this._linkStore = factory.createStore(linkConn, false, false);
        }
    }

    public void commit() {
        try {
            this._entityStore.commit();
            this._linkStore.commit();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

