/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.graph.store.pandora.layout;

import com.paterva.graph.store.pandora.layout.LayoutArtifactUtils;
import com.paterva.graph.store.pandora.layout.LayoutCache;
import com.paterva.graph.store.pandora.parts.PandoraPartsWriter;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.GraphUserData;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.layout.GraphLayoutMods;
import com.paterva.maltego.graph.store.layout.GraphLayoutWriter;
import com.pinkmatter.pandora.PandoraException;
import java.awt.Point;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class PandoraGraphLayoutWriter
extends PandoraPartsWriter
implements GraphLayoutWriter {
    private static final Logger LOG = Logger.getLogger(PandoraGraphLayoutWriter.class.getName());
    private GraphLayoutMods _eventMods;

    PandoraGraphLayoutWriter(GraphID id, PropertyChangeSupport changeSupport) {
        super(id, changeSupport);
    }

    @Override
    public void commit() {
        try {
            this.writePoints();
            this.writePaths();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        super.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntities(Map<EntityID, Point> centers) throws GraphStoreException {
        try {
            this.beginUpdate();
            for (Map.Entry<EntityID, Point> entry : centers.entrySet()) {
                EntityID entityID = entry.getKey();
                Point center = entry.getValue();
                this.addEntity(entityID, center);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntities(Collection<EntityID> entityIDs) throws GraphStoreException {
        try {
            this.beginUpdate();
            for (EntityID entityID : entityIDs) {
                this.addEntity(entityID);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void addEntity(EntityID entityID, Point center) throws GraphStoreException {
        try {
            this.beginUpdate();
            LOG.log(Level.FINE, "Add entity {0}", entityID);
            LayoutCache layoutCache = this.getLayoutCache();
            if (layoutCache.getAddedEntities().contains(entityID)) {
                throw new GraphStoreException("Entity already exists: " + entityID);
            }
            this.getEventMods().getCenters().put(entityID, center);
            layoutCache.addEntity(entityID, center);
        }
        catch (Exception ex) {
            if (ex instanceof GraphStoreException) {
                throw (GraphStoreException)ex;
            }
            throw new GraphStoreException((Throwable)ex);
        }
        finally {
            this.endUpdate();
        }
    }

    public void addEntity(EntityID entityID) throws GraphStoreException {
        this.addEntity(entityID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLinks(Map<LinkID, List<Point>> paths) throws GraphStoreException {
        try {
            this.beginUpdate();
            for (Map.Entry<LinkID, List<Point>> entry : paths.entrySet()) {
                LinkID linkID = entry.getKey();
                List<Point> path = entry.getValue();
                this.addLink(linkID, path);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLinks(Collection<LinkID> linkIDs) throws GraphStoreException {
        try {
            this.beginUpdate();
            for (LinkID linkID : linkIDs) {
                this.addLink(linkID);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void addLink(LinkID linkID, List<Point> path) throws GraphStoreException {
        try {
            this.beginUpdate();
            LOG.log(Level.FINE, "Add link {0}", linkID);
            LayoutCache layoutCache = this.getLayoutCache();
            if (layoutCache.getAddedLinks().contains(linkID)) {
                throw new GraphStoreException("Link already exists: " + linkID);
            }
            this.getEventMods().getPaths().put(linkID, path);
            layoutCache.addLink(linkID, path);
        }
        catch (Exception ex) {
            if (ex instanceof GraphStoreException) {
                throw (GraphStoreException)ex;
            }
            throw new GraphStoreException((Throwable)ex);
        }
        finally {
            this.endUpdate();
        }
    }

    public void addLink(LinkID linkID) throws GraphStoreException {
        this.addLink(linkID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCenters(Map<EntityID, Point> centers) throws GraphStoreException {
        try {
            this.beginUpdate();
            for (Map.Entry<EntityID, Point> entry : centers.entrySet()) {
                EntityID entityID = entry.getKey();
                Point center = entry.getValue();
                this.setCenter(entityID, center);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void setCenter(EntityID entity, Point center) throws GraphStoreException {
        if (center == null) {
            return;
        }
        try {
            this.beginUpdate();
            LOG.log(Level.FINE, "Update center {0}: {1}", new Object[]{entity, center});
            this.getEventMods().getCenters().put(entity, center);
            this.getCenterCache().put(entity, center);
        }
        catch (Exception ex) {
            throw new GraphStoreException((Throwable)ex);
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPaths(Map<LinkID, List<Point>> paths) throws GraphStoreException {
        try {
            this.beginUpdate();
            for (Map.Entry<LinkID, List<Point>> entry : paths.entrySet()) {
                LinkID linkID = entry.getKey();
                List<Point> path = entry.getValue();
                this.setPath(linkID, path);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void setPath(LinkID link, List<Point> path) throws GraphStoreException {
        if (path == null) {
            return;
        }
        try {
            this.beginUpdate();
            LOG.log(Level.FINE, "Update path {0}: {1}", new Object[]{link, path});
            this.getEventMods().getPaths().put(link, path);
            this.getPathsCache().put(link, path);
        }
        catch (Exception ex) {
            throw new GraphStoreException((Throwable)ex);
        }
        finally {
            this.endUpdate();
        }
    }

    public void removeEntities(Collection<EntityID> entities) throws GraphStoreException {
        this.remove(entities, Collections.EMPTY_SET);
    }

    public void removeEntity(EntityID entityID) throws GraphStoreException {
        this.removeEntities(Collections.singleton(entityID));
    }

    public void removeLinks(Collection<LinkID> links) throws GraphStoreException {
        this.remove(Collections.EMPTY_SET, links);
    }

    public void removeLink(LinkID linkID) throws GraphStoreException {
        this.removeLinks(Collections.singleton(linkID));
    }

    public void remove(Collection<EntityID> entities, Collection<LinkID> links) throws GraphStoreException {
        try {
            this.beginUpdate();
            LayoutCache layoutCache = this.getLayoutCache();
            Set<EntityID> addedEntities = layoutCache.getAddedEntities();
            this.getCenterCache().keySet().removeAll(entities);
            for (EntityID entityID : entities) {
                LOG.log(Level.FINE, "Remove entity {0}", entityID);
                if (!addedEntities.remove(entityID)) {
                    this.getEntityStore().remove(entityID.getValue());
                }
                this.getEventMods().getCenters().remove(entityID);
            }
            Set<LinkID> addedLinks = layoutCache.getAddedLinks();
            this.getPathsCache().keySet().removeAll(links);
            for (LinkID linkID : links) {
                LOG.log(Level.FINE, "Remove link {0}", linkID);
                if (!addedLinks.remove(linkID)) {
                    this.getLinkStore().remove(linkID.getValue());
                }
                this.getEventMods().getPaths().remove(linkID);
            }
        }
        catch (Exception ex) {
            throw new GraphStoreException((Throwable)ex);
        }
        finally {
            this.endUpdate();
        }
    }

    public void clear() throws GraphStoreException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    protected void fireEvent() {
        if (this._eventMods != null && !this._eventMods.isEmpty()) {
            GraphLayoutMods eventMods = this._eventMods;
            this._eventMods = null;
            if (!eventMods.isEmpty()) {
                LOG.log(Level.FINE, "Fire events: {0}", eventMods);
                eventMods.makeReadOnly();
                this.getChangeSupport().firePropertyChange("layoutModified", null, eventMods);
            }
        }
    }

    private GraphLayoutMods getEventMods() {
        if (this._eventMods == null) {
            this._eventMods = new GraphLayoutMods();
        }
        return this._eventMods;
    }

    private Map<EntityID, Point> getCenterCache() {
        return this.getLayoutCache().getCenterCache();
    }

    private Map<LinkID, List<Point>> getPathsCache() {
        return this.getLayoutCache().getPathsCache();
    }

    private LayoutCache getLayoutCache() {
        String key;
        GraphUserData gud = GraphUserData.forGraph((GraphID)this.getGraphID());
        LayoutCache cache = (LayoutCache)gud.get((Object)(key = LayoutCache.class.getName()));
        if (cache == null) {
            cache = new LayoutCache();
            gud.put((Object)key, (Object)cache);
        }
        return cache;
    }

    private void writePoints() throws PandoraException {
        Map<EntityID, Point> cache = this.getCenterCache();
        Set<EntityID> addedEntities = this.getLayoutCache().getAddedEntities();
        for (Map.Entry<EntityID, Point> entry : cache.entrySet()) {
            EntityID entityID = entry.getKey();
            Point center = entry.getValue();
            long longID = entityID.getValue();
            Map<String, Object> centerMap = LayoutArtifactUtils.createCenterMap(center);
            if (!addedEntities.contains(entityID)) {
                this.getEntityStore().remove(longID);
            }
            this.getEntityStore().add(longID, centerMap);
        }
        addedEntities.clear();
    }

    private void writePaths() throws PandoraException {
        Map<LinkID, List<Point>> cache = this.getPathsCache();
        Set<LinkID> addedLinks = this.getLayoutCache().getAddedLinks();
        for (Map.Entry<LinkID, List<Point>> entry : cache.entrySet()) {
            LinkID linkID = entry.getKey();
            List<Point> path = entry.getValue();
            long longID = linkID.getValue();
            Map<String, Object> pathMap = LayoutArtifactUtils.createPathMap(path);
            if (!addedLinks.contains(linkID)) {
                this.getLinkStore().remove(longID);
            }
            this.getLinkStore().add(longID, pathMap);
        }
        addedLinks.clear();
    }
}

