/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.importexport.previous;

import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigImporter;
import com.paterva.maltego.importexport.nodes.AllConfigsNode;
import com.paterva.maltego.importexport.previous.PreviousConfigs;
import com.paterva.maltego.importexport.previous.PreviousVersion;
import com.paterva.maltego.importexport.previous.PreviousVersionsPanel;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.TreeMap;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

public class PreviousVersionsController
extends ValidatingController<PreviousVersionsPanel> {
    public PreviousVersionsController() {
        this.setName("Choose Version");
    }

    protected PreviousVersionsPanel createComponent() {
        return new PreviousVersionsPanel();
    }

    protected void readSettings(WizardDescriptor settings) {
        Object icon;
        Object description = settings.getProperty("previous_version_description");
        if (description != null) {
            this.setDescription((String)description);
        }
        if ((icon = settings.getProperty("previous_version_icon")) != null) {
            this.setImage(ImageUtilities.loadImage((String)((String)icon).replace(".png", "48.png")));
        }
        PreviousVersion[] versions = (PreviousVersion[])settings.getProperty("previousVersions");
        PreviousVersion selected = (PreviousVersion)settings.getProperty("selectedVersion");
        ((PreviousVersionsPanel)this.component()).setVersions(versions);
        if (selected != null) {
            ((PreviousVersionsPanel)this.component()).setSelectedVersion(selected);
        }
    }

    protected void storeSettings(WizardDescriptor settings) {
        try {
            PreviousVersion version = ((PreviousVersionsPanel)this.component()).getSelectedVersion();
            settings.putProperty("selectedVersion", (Object)version);
            ConfigImporter[] importers = (ConfigImporter[])settings.getProperty("importers");
            File prevConfDir = new File(version.getPath(), "config");
            FileObject configRoot = PreviousConfigs.createConfigRoot(prevConfDir);
            TreeMap<Config, ConfigImporter> configsMap = PreviousConfigs.loadConfigs(importers, configRoot);
            settings.putProperty("configsMap", configsMap);
            settings.putProperty("allConfigs", (Object)new AllConfigsNode(configsMap.keySet(), true));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (PropertyVetoException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

