/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.registry;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.registry.Level1EntityRegistry;
import com.paterva.maltego.entity.registry.Level2EntityRegistry;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import java.awt.event.ActionEvent;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

public class RestoreEntitiesAction
extends SystemAction {
    public String getName() {
        return "Reset Entities";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void actionPerformed(ActionEvent ev) {
        this.perform(true);
    }

    public void perform(boolean revertModified) {
        EntityRegistry currentRegistry = EntityRegistry.getDefault();
        this.copyEntities(currentRegistry, new Level1EntityRegistry(), revertModified);
        this.copyEntities(currentRegistry, new Level2EntityRegistry(), revertModified);
    }

    private void copyEntities(EntityRegistry toRegistry, EntityRegistry fromRegistry, boolean revertModified) {
        for (MaltegoEntitySpec maltegoEntitySpec : fromRegistry.getAll()) {
            boolean exist = toRegistry.contains(maltegoEntitySpec.getTypeName());
            if (!exist) {
                toRegistry.put((TypeSpec)maltegoEntitySpec);
                continue;
            }
            if (!revertModified) continue;
            toRegistry.remove(maltegoEntitySpec.getTypeName());
            toRegistry.put((TypeSpec)maltegoEntitySpec);
        }
    }
}

