/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.registry;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.registry.Level1EntityRegistry;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.TypeNameValidatorLogger;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import java.util.Collection;
import java.util.prefs.Preferences;
import org.openide.modules.ModuleInstall;
import org.openide.util.NbPreferences;

public class Installer
extends ModuleInstall {
    private static final String PREF_IP_ENTITIES_ADDED = "maltego.entities.ip.added";
    private static final String ENTITY_IP = "maltego.IPAddress";
    private static final String ENTITY_IPv4 = "maltego.IPv4Address";
    private static final String ENTITY_IPv6 = "maltego.IPv6Address";
    private static final String ENTITY_NETWORK = "maltego.Network";
    private static final String ENTITY_NETBLOCK = "maltego.Netblock";
    private static final String ENTITY_NETBLOCK_IPv6 = "maltego.NetblockIPv6";

    public void restored() {
        Preferences prefs = NbPreferences.forModule(((Object)((Object)this)).getClass());
        EntityRegistry registry = EntityRegistry.getDefault();
        if (!prefs.getBoolean(PREF_IP_ENTITIES_ADDED, false)) {
            if (registry.get(ENTITY_IPv4) != null && registry.get(ENTITY_IP) == null) {
                Level1EntityRegistry level1Registry = new Level1EntityRegistry();
                this.reAddEntity(registry, level1Registry, ENTITY_IP);
                this.reAddEntity(registry, level1Registry, ENTITY_IPv4);
                this.reAddEntity(registry, level1Registry, ENTITY_IPv6);
                this.reAddEntity(registry, level1Registry, ENTITY_NETWORK);
                this.reAddEntity(registry, level1Registry, ENTITY_NETBLOCK);
                this.reAddEntity(registry, level1Registry, ENTITY_NETBLOCK_IPv6);
            }
            prefs.putBoolean(PREF_IP_ENTITIES_ADDED, true);
        }
        this.checkPropertyNames(registry);
    }

    private void checkPropertyNames(EntityRegistry registry) {
        TypeNameValidatorLogger typeNameLogger = TypeNameValidatorLogger.getDefault();
        Collection specs = registry.getAll();
        specs.forEach(spec -> {
            String entityDisplayName = spec.getDisplayName();
            String typeName = spec.getTypeName();
            DisplayDescriptorCollection properties = spec.getProperties();
            properties.stream().map(pd -> pd.getName()).forEachOrdered(propName -> typeNameLogger.handleIfInvalid(entityDisplayName, typeName, propName, null));
        });
    }

    private void reAddEntity(EntityRegistry registry, Level1EntityRegistry level1Registry, String name) {
        MaltegoEntitySpec spec = level1Registry.get(name);
        if (spec != null) {
            if (!registry.contains(name)) {
                registry.put((TypeSpec)spec);
            } else {
                registry.remove(name);
                registry.put((TypeSpec)spec);
            }
        }
    }
}

