/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.propertygrid;

import com.paterva.maltego.core.GenericEntity;
import com.paterva.maltego.core.GenericPart;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.ImageUtils;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Image;
import java.lang.reflect.InvocationTargetException;
import javax.swing.ImageIcon;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;

public class PropertyDescriptorProperty
extends Node.Property {
    private DataSource _data;
    private PropertyDescriptor _descriptor;
    private static final ImageIcon EMPTY_ICON = new ImageIcon();

    public PropertyDescriptorProperty(PropertyDescriptor descriptor, DataSource data) {
        this(descriptor.getType(), descriptor, data);
    }

    public PropertyDescriptorProperty(Class type, PropertyDescriptor descriptor, DataSource data) {
        super(type);
        if (descriptor == null) {
            throw new IllegalArgumentException("Descriptor cannot be null");
        }
        this._data = data;
        this._descriptor = descriptor;
        this.setName(descriptor.getName());
        this.setShortDescription(descriptor.getDescription());
        this.setDisplayName(descriptor.getDisplayName());
        this.refresh();
    }

    public DataSource getDataSource() {
        return this._data;
    }

    public void setDataSource(DataSource dataSource) {
        this._data = dataSource;
    }

    protected PropertyDescriptor getPropertyDescriptor() {
        return this._descriptor;
    }

    public String getHtmlDisplayName() {
        String colorSuffix;
        String colorPrefix;
        block8: {
            if (this._descriptor.getHtmlDisplayName() != null) {
                return this._descriptor.getHtmlDisplayName();
            }
            colorPrefix = "";
            colorSuffix = "";
            if (!this.getPropertyDescriptor().isNullable()) {
                try {
                    Object value = this.getValue();
                    if (value == null || value.toString().isEmpty()) {
                        colorPrefix = "<font color=\"#FF0000\">";
                        colorSuffix = " *</font>";
                        break block8;
                    }
                    colorSuffix = "<font color=\"#FF0000\"> *</font> ";
                }
                catch (IllegalAccessException value) {
                }
                catch (InvocationTargetException value) {}
            } else if (this.getPropertyDescriptor().isHidden()) {
                colorPrefix = colorPrefix + "<font color=\"#808080\">";
                colorSuffix = "</font>" + colorSuffix;
            }
        }
        String htmlDisplayName = colorPrefix + this.getDisplayName() + colorSuffix;
        this._descriptor.setHtmlDisplayName(htmlDisplayName);
        return htmlDisplayName;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        Object value = this._data.getValue(this._descriptor);
        value = StringUtilities.trimIfNotBlank((Object)value);
        this.updateDisplay(value);
        return value;
    }

    public void setValue(Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        value = StringUtilities.trimIfNotBlank((Object)value);
        if (this._data instanceof GenericPart) {
            ((GenericPart)this._data).setValue(this._descriptor, value, true, true);
            if (this._data instanceof GenericEntity) {
                PropertyDescriptorProperty.setImageExpressionIfBase64((GenericEntity)this._data, this._descriptor, value);
            }
        } else {
            this._data.setValue(this._descriptor, value);
        }
        this.updateDisplay(value);
    }

    public boolean isHidden() {
        return this._descriptor.isHidden();
    }

    public boolean canWrite() {
        return !this._descriptor.isReadonly();
    }

    public boolean canRead() {
        return true;
    }

    public void refresh() {
        Image image = null;
        if (this._descriptor.getImage() != null) {
            image = ImageUtilities.loadImage((String)this._descriptor.getImage());
        }
        if (image != null) {
            this.setValue("nameIcon", new ImageIcon(image));
        } else {
            this.setValue("nameIcon", EMPTY_ICON);
        }
    }

    protected void updateDisplay(Object value) {
    }

    private static void setImageExpressionIfBase64(GenericEntity entity, PropertyDescriptor descriptor, Object value) {
        String valueString;
        if (!entity.getImageExpression().isPresent() && "base64".equals(descriptor.getName()) && value instanceof String && ImageUtils.isPossibleBase64Image((String)(valueString = (String)value)) && ImageUtils.getSizeInBytesEstimate((String)valueString, (boolean)true) < 0x100000 && ImageUtils.canDisplayBase64Image((String)valueString)) {
            entity.setImageExpression(descriptor.getName());
        }
    }
}

