/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.controls;

import com.paterva.maltego.util.ui.ColorButton;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.openide.util.NbBundle;

public class ColorChooserPanel
extends JPanel {
    private Color _defaultColor;
    private PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);
    private JButton _changeColorButton;
    private JButton _linkColorButton;

    public ColorChooserPanel() {
        this.initComponents();
    }

    public Color getColor() {
        return this._defaultColor;
    }

    public void setColor(Color color) {
        Color oldColor = this._defaultColor;
        this._defaultColor = color;
        this._changeSupport.firePropertyChange("ColorChanged", oldColor, this._defaultColor);
        this.updateLinkColorButton();
    }

    public void addColorChangeListener(PropertyChangeListener pcl) {
        this._changeSupport.addPropertyChangeListener(pcl);
    }

    public void removeColorChangeListener(PropertyChangeListener pcl) {
        this._changeSupport.removePropertyChangeListener(pcl);
    }

    private void initComponents() {
        this._linkColorButton = new ColorButton();
        this._changeColorButton = new JButton();
        this._linkColorButton.setText(NbBundle.getMessage(ColorChooserPanel.class, (String)"ColorChooserPanel._linkColorButton.text"));
        this._linkColorButton.setMaximumSize(new Dimension(15, 15));
        this._linkColorButton.setMinimumSize(new Dimension(15, 15));
        this._linkColorButton.setPreferredSize(new Dimension(15, 15));
        this._linkColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorChooserPanel.this._linkColorButtonActionPerformed(evt);
            }
        });
        this._changeColorButton.setText(NbBundle.getMessage(ColorChooserPanel.class, (String)"ColorChooserPanel._changeColorButton.text"));
        this._changeColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColorChooserPanel.this._changeColorButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this._linkColorButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._changeColorButton)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._changeColorButton).addComponent(this._linkColorButton, -2, -1, -2)));
    }

    private void _linkColorButtonActionPerformed(ActionEvent evt) {
    }

    private void _changeColorButtonActionPerformed(ActionEvent evt) {
        Color newColor = JColorChooser.showDialog(this, "Choose a Link Color", this._defaultColor);
        if (newColor != null) {
            this.setColor(newColor);
        }
        this.updateLinkColorButton();
    }

    private void updateLinkColorButton() {
        this._linkColorButton.setBackground(this._defaultColor);
    }
}

