/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.spi;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.keycloak.adapters.spi.SessionIdMapper;

public class InMemorySessionIdMapper
implements SessionIdMapper {
    private static final Logger LOG = Logger.getLogger((String)InMemorySessionIdMapper.class.getName());
    ConcurrentHashMap<String, String> ssoToSession = new ConcurrentHashMap();
    ConcurrentHashMap<String, String> sessionToSso = new ConcurrentHashMap();
    ConcurrentHashMap<String, Set<String>> principalToSession = new ConcurrentHashMap();
    ConcurrentHashMap<String, String> sessionToPrincipal = new ConcurrentHashMap();

    @Override
    public boolean hasSession(String id) {
        return this.sessionToSso.containsKey(id) || this.sessionToPrincipal.containsKey(id);
    }

    @Override
    public void clear() {
        this.ssoToSession.clear();
        this.sessionToSso.clear();
        this.principalToSession.clear();
        this.sessionToPrincipal.clear();
    }

    @Override
    public Set<String> getUserSessions(String principal) {
        Set<String> lookup = this.principalToSession.get(principal);
        if (lookup == null) {
            return null;
        }
        HashSet<String> copy = new HashSet<String>();
        copy.addAll(lookup);
        return copy;
    }

    @Override
    public String getSessionFromSSO(String sso) {
        return this.ssoToSession.get(sso);
    }

    @Override
    public void map(String sso, String principal, String session) {
        Set tmp;
        LOG.debugf("Adding mapping (%s, %s, %s)", (Object)sso, (Object)principal, (Object)session);
        if (sso != null) {
            this.ssoToSession.put(sso, session);
            this.sessionToSso.put(session, sso);
        }
        if (principal == null) {
            return;
        }
        Set<String> userSessions = this.principalToSession.get(principal);
        if (userSessions == null && (userSessions = this.principalToSession.putIfAbsent(principal, tmp = Collections.synchronizedSet(new HashSet()))) == null) {
            userSessions = tmp;
        }
        userSessions.add(session);
        this.sessionToPrincipal.put(session, principal);
    }

    @Override
    public void removeSession(String session) {
        String principal;
        LOG.debugf("Removing session %s", (Object)session);
        String sso = this.sessionToSso.remove(session);
        if (sso != null) {
            this.ssoToSession.remove(sso);
        }
        if ((principal = this.sessionToPrincipal.remove(session)) != null) {
            Set<String> sessions = this.principalToSession.get(principal);
            sessions.remove(session);
            if (sessions.isEmpty()) {
                this.principalToSession.remove(principal, sessions);
            }
        }
    }
}

