/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.imex;

import com.paterva.maltego.archive.mtz.EntryFactory;
import com.paterva.maltego.archive.mtz.MaltegoArchiveReader;
import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.MachineRepository;
import com.paterva.maltego.automation.imex.MachineAttributesEntryFactory;
import com.paterva.maltego.automation.imex.MachineAttributesWrapper;
import com.paterva.maltego.automation.imex.MachineEntryFactory;
import com.paterva.maltego.automation.imex.MachineWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openide.util.Exceptions;

public class MachineImporter {
    public List<MachineDescriptor> read(MaltegoArchiveReader reader) throws IOException {
        List wrappers = reader.readAll((EntryFactory)new MachineEntryFactory(), "Graph1");
        if (wrappers.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List attributes = reader.readAll((EntryFactory)new MachineAttributesEntryFactory(), "Graph1");
        List<MachineDescriptor> machines = this.getMachines(wrappers, attributes);
        return machines;
    }

    public int apply(Collection<MachineDescriptor> machines, String hubItem) {
        MachineRepository repo = MachineRepository.getDefault();
        int count = 0;
        for (MachineDescriptor machine : machines) {
            try {
                MachineDescriptor oldMachine;
                if (hubItem != null) {
                    machine.addHubItem(hubItem);
                }
                if ((oldMachine = repo.get(machine.getName())) != null) {
                    if (!oldMachine.isCopy(machine)) {
                        repo.remove(oldMachine);
                        this.transferHubItems(oldMachine, machine);
                        repo.add(machine);
                    }
                } else {
                    repo.add(machine);
                }
                ++count;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return count;
    }

    private List<MachineDescriptor> getMachines(List<MachineWrapper> wrappers, List<MachineAttributesWrapper> attributesWrappers) {
        ArrayList<MachineDescriptor> machines = new ArrayList<MachineDescriptor>();
        for (MachineWrapper wrapper : wrappers) {
            MachineDescriptor machine = wrapper.getMachine();
            for (MachineAttributesWrapper attributes : attributesWrappers) {
                if (!wrapper.getFileName().equals(attributes.getFileName())) continue;
                machine.setEnabled(attributes.isEnabled());
                machine.setFavorite(attributes.isFavorite());
            }
            machines.add(machine);
        }
        return machines;
    }

    private void transferHubItems(MachineDescriptor oldMachine, MachineDescriptor newMachine) {
        for (String oldHubitem : oldMachine.getHubItems()) {
            if (newMachine.getHubItems().contains(oldHubitem)) continue;
            newMachine.addHubItem(oldHubitem);
        }
    }
}

