/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v3.api;

import com.maltego.tx3.java.api.execution.Button;
import com.maltego.tx3.java.api.execution.UiMessage;
import com.paterva.maltego.transform.api.TransformMessage;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class V3ProxyMessageTranslater {
    public static List<TransformMessage> translate(List<UiMessage> messages, int statusCode) {
        if (messages == null || messages.isEmpty()) {
            return new ArrayList<TransformMessage>(0);
        }
        ArrayList<TransformMessage> results = new ArrayList<TransformMessage>(messages.size());
        for (UiMessage message : messages) {
            results.add(V3ProxyMessageTranslater.translate(message, statusCode));
        }
        return results;
    }

    public static TransformMessage translate(UiMessage message, int statusCode) {
        return new TransformMessage(new Date(), V3ProxyMessageTranslater.translate(message.getType()), message.getText(), statusCode, V3ProxyMessageTranslater.translateButtons(message.getButtons()));
    }

    private static TransformMessage.Severity translate(String s) {
        if (null == s) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        switch (s) {
            case "Debug": {
                return TransformMessage.Severity.Debug;
            }
            case "Inform": {
                return TransformMessage.Severity.Info;
            }
            case "PartialError": {
                return TransformMessage.Severity.Warning;
            }
            case "FatalError": {
                return TransformMessage.Severity.Error;
            }
        }
        throw new IllegalArgumentException("Invalid type " + s);
    }

    private static List<TransformMessage.MessageButton> translateButtons(List<Button> buttons) {
        ArrayList<TransformMessage.MessageButton> messageButtons = new ArrayList<TransformMessage.MessageButton>();
        for (Button button : buttons) {
            messageButtons.add(new TransformMessage.MessageButton(button.getId(), button.getText(), button.getUrl()));
        }
        return messageButtons;
    }
}

