/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v3.api;

import com.maltego.tx3.java.api.execution.Entity;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.store.GraphFactory;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.wrapper.GraphStoreWriter;
import com.paterva.maltego.matching.TypeToPropertiesMapMatchingRuleDescriptor;
import com.paterva.maltego.matching.api.MatchingRuleDescriptor;
import com.paterva.maltego.transform.protocol.v3.api.TransformRunResultCache;
import com.paterva.maltego.transform.protocol.v3.api.TransformRunResultPage;
import com.paterva.maltego.transform.protocol.v3.api.TransformRunResultPageMergeResults;
import com.paterva.maltego.transform.protocol.v3.api.V3ProtocolTranslator;
import com.paterva.maltego.transform.runner.api.EntityMerger;
import com.paterva.maltego.transform.runner.api.MatchingRuleUpdater;
import com.paterva.maltego.transform.runner.api.TransformRunContext;
import com.paterva.maltego.typing.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class TransformRunResultPageMerger
extends MatchingRuleUpdater {
    private final TransformRunResultCache cache;
    private final TransformRunContext ctx;
    private GraphID graphId = null;
    private final int entityLimit;

    TransformRunResultPageMerger(TransformRunContext ctx, TransformRunResultCache cache, int entityLimit) {
        this.ctx = ctx;
        try {
            this.graphId = GraphFactory.getDefault().createInvisibleInMemoryGraph();
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.cache = cache;
        this.entityLimit = entityLimit;
    }

    TransformRunResultPageMergeResults mergeAndApply(TransformRunResultPage page) {
        Map inputEntityMap = this.ctx.getInputEntities();
        HashMap<EntityID, List<EntityID>> inputToOutputEntities = new HashMap<EntityID, List<EntityID>>();
        Set<MaltegoEntity> addedEntities = page.getAddedEntities();
        this.cache.addEntities(addedEntities);
        TypeToPropertiesMapMatchingRuleDescriptor matchingRule = this.updateMatchingRule(this.ctx, addedEntities);
        Map mergedEntityMap = EntityMerger.getMerged((TransformRunContext)this.ctx, addedEntities, (MatchingRuleDescriptor)matchingRule);
        this.cache.applyEntityMergeResults(mergedEntityMap);
        this.cache.addLinks(page.getAddedLinks());
        HashSet<Object> mergedAndAddedToGraphEntityIds = new HashSet<Object>();
        HashSet<LinkID> mergedAndAddedToGraphLinkIds = new HashSet<LinkID>();
        HashSet<MaltegoEntity> deletedEntities = new HashSet<MaltegoEntity>();
        HashSet<LinkID> deletedLinkIds = new HashSet<LinkID>();
        for (TransformRunResultPage.PageOperation operation : page.getOperationQueue()) {
            EntityID addedEntityId;
            MaltegoEntity addedEntity;
            if (operation instanceof TransformRunResultPage.PageEntityUpdateOperation) {
                EntityID updatedEntityId = ((TransformRunResultPage.PageEntityUpdateOperation)operation).getEntityId();
                MaltegoEntity entityToUpdate = inputEntityMap.containsKey(updatedEntityId) ? (MaltegoEntity)inputEntityMap.get(updatedEntityId) : this.cache.getMergedEntity(updatedEntityId);
                Entity updateEntity = ((TransformRunResultPage.PageEntityUpdateOperation)operation).getEntity();
                V3ProtocolTranslator.translate(updateEntity, entityToUpdate);
                if (mergedAndAddedToGraphEntityIds.contains(entityToUpdate.getID())) {
                    GraphStoreWriter.updateEntity((GraphID)this.graphId, (MaltegoEntity)entityToUpdate);
                } else {
                    GraphStoreWriter.addEntity((GraphID)this.graphId, (MaltegoEntity)entityToUpdate);
                    mergedAndAddedToGraphEntityIds.add(entityToUpdate.getID());
                }
            }
            if (operation instanceof TransformRunResultPage.PageEntityAddOperation && this.cache.getAddedEntityCount() < this.entityLimit && !mergedAndAddedToGraphEntityIds.contains((addedEntity = this.cache.getMergedEntity(addedEntityId = ((TransformRunResultPage.PageEntityAddOperation)operation).getEntityId())).getID())) {
                GraphStoreWriter.addEntity((GraphID)this.graphId, (MaltegoEntity)addedEntity);
                mergedAndAddedToGraphEntityIds.add(addedEntity.getID());
                this.cache.incrementAddedEntityCount();
                for (MaltegoEntity input : inputEntityMap.values()) {
                    if (inputToOutputEntities.containsKey(input.getID())) {
                        ((List)inputToOutputEntities.get(input.getID())).add(addedEntityId);
                        continue;
                    }
                    inputToOutputEntities.put((EntityID)input.getID(), new ArrayList<EntityID>(Arrays.asList(addedEntityId)));
                }
            }
            if (operation instanceof TransformRunResultPage.PageEntityDeleteOperation) {
                MaltegoEntity deletedEntity;
                EntityID deletedEntityId = ((TransformRunResultPage.PageEntityDeleteOperation)operation).getEntityId();
                if (inputEntityMap.containsKey(deletedEntityId)) {
                    deletedEntity = (MaltegoEntity)inputEntityMap.get(deletedEntityId);
                } else {
                    deletedEntity = this.cache.getMergedEntity(deletedEntityId);
                    EntityID mergedEntityId = this.cache.getMergedEntityId(deletedEntityId);
                    if (mergedAndAddedToGraphEntityIds.contains(mergedEntityId)) {
                        GraphStoreWriter.removeEntities((GraphID)this.graphId, new HashSet<EntityID>(Arrays.asList(mergedEntityId)));
                        mergedAndAddedToGraphEntityIds.remove(mergedEntityId);
                    }
                }
                deletedEntities.add(deletedEntity);
            }
            if (operation instanceof TransformRunResultPage.PageLinkAddOperation) {
                boolean entityLimitReached = this.cache.getAddedEntityCount() >= this.entityLimit;
                TransformRunResultPage.PageLinkAddOperation addedLinkOperation = (TransformRunResultPage.PageLinkAddOperation)operation;
                MaltegoLink addedLink = addedLinkOperation.getLink();
                LinkID addedLinkId = addedLinkOperation.getLinkId();
                if (!mergedAndAddedToGraphLinkIds.contains(addedLinkId)) {
                    LinkEntityIDs addedLinkEntityIDs;
                    EntityID targetEntityId;
                    EntityID mergedTargetEntityId;
                    EntityID sourceEntityId = ((TransformRunResultPage.PageLinkAddOperation)operation).getSourceEntityId();
                    EntityID mergedSourceEntityId = this.cache.getMergedEntityId(sourceEntityId);
                    if (!mergedAndAddedToGraphEntityIds.contains(mergedSourceEntityId) && !entityLimitReached) {
                        if (inputEntityMap.containsKey(mergedSourceEntityId)) {
                            GraphStoreWriter.addEntity((GraphID)this.graphId, (MaltegoEntity)((MaltegoEntity)inputEntityMap.get(mergedSourceEntityId)));
                        } else {
                            MaltegoEntity sourceMergedEntity = this.cache.getMergedEntity(mergedSourceEntityId);
                            GraphStoreWriter.addEntity((GraphID)this.graphId, (MaltegoEntity)sourceMergedEntity);
                        }
                        mergedAndAddedToGraphEntityIds.add(mergedSourceEntityId);
                    }
                    if (!mergedAndAddedToGraphEntityIds.contains(mergedTargetEntityId = this.cache.getMergedEntityId(targetEntityId = ((TransformRunResultPage.PageLinkAddOperation)operation).getTargetEntityId())) && !entityLimitReached) {
                        if (inputEntityMap.containsKey(mergedTargetEntityId)) {
                            GraphStoreWriter.addEntity((GraphID)this.graphId, (MaltegoEntity)((MaltegoEntity)inputEntityMap.get(mergedTargetEntityId)));
                        } else {
                            MaltegoEntity sourceTargetEntity = this.cache.getMergedEntity(mergedTargetEntityId);
                            GraphStoreWriter.addEntity((GraphID)this.graphId, (MaltegoEntity)sourceTargetEntity);
                        }
                        mergedAndAddedToGraphEntityIds.add(mergedTargetEntityId);
                    }
                    if ((mergedAndAddedToGraphEntityIds.contains((addedLinkEntityIDs = this.cache.getMergedLinkEntityIds(sourceEntityId, targetEntityId)).getSourceID()) || inputEntityMap.containsKey(sourceEntityId)) && mergedAndAddedToGraphEntityIds.contains(addedLinkEntityIDs.getTargetID()) && !this.isDuplicateLink(addedLink, mergedSourceEntityId, mergedTargetEntityId)) {
                        if (inputEntityMap.containsKey(sourceEntityId) && !mergedAndAddedToGraphEntityIds.contains(addedLinkEntityIDs.getSourceID())) {
                            GraphStoreWriter.addEntity((GraphID)this.graphId, (MaltegoEntity)((MaltegoEntity)inputEntityMap.get(sourceEntityId)));
                        }
                        GraphStoreWriter.addLink((GraphID)this.graphId, (MaltegoLink)addedLink, (LinkEntityIDs)addedLinkEntityIDs);
                        mergedAndAddedToGraphLinkIds.add(addedLinkId);
                    }
                }
            }
            if (!(operation instanceof TransformRunResultPage.PageLinkDeleteOperation)) continue;
            LinkID deletedLinkId = ((TransformRunResultPage.PageLinkDeleteOperation)operation).getLinkId();
            deletedLinkIds.add(deletedLinkId);
        }
        HashMap<MaltegoLink, LinkEntityIDs> deletedLinks = new HashMap<MaltegoLink, LinkEntityIDs>();
        for (LinkID deletedLinkId : deletedLinkIds) {
            Set inputLinkIds = this.ctx.getInputLinks().keySet().stream().map(ie -> (LinkID)ie.getID()).collect(Collectors.toSet());
            if (inputLinkIds.contains(deletedLinkId)) {
                for (Map.Entry inputEntity : this.ctx.getInputLinks().entrySet()) {
                    if (!((LinkID)((MaltegoLink)inputEntity.getKey()).getID()).equals((Object)deletedLinkId)) continue;
                    deletedLinks.put((MaltegoLink)inputEntity.getKey(), (LinkEntityIDs)inputEntity.getValue());
                }
            }
            deletedLinks.putAll(this.cache.getMergedLink(deletedLinkId));
        }
        return new TransformRunResultPageMergeResults(this.graphId, inputToOutputEntities, deletedEntities, deletedLinks, mergedEntityMap.size());
    }

    private boolean isDuplicateLink(MaltegoLink newLink, EntityID mergedSourceEntityId, EntityID mergedTargetEntityId) {
        EntityID targetMergedEntityId;
        EntityID srcMergedEntityId = this.cache.getMergedEntityId(mergedSourceEntityId);
        LinkEntityIDs mergedLinkEntityId = new LinkEntityIDs(srcMergedEntityId, targetMergedEntityId = this.cache.getMergedEntityId(mergedTargetEntityId));
        Set<MaltegoLink> linksBetweenEntity = this.cache.getMergedLinksBetweenEntities(mergedLinkEntityId);
        if (linksBetweenEntity.isEmpty()) {
            this.cache.addLinksBetweenEntities(mergedLinkEntityId, newLink);
            return false;
        }
        int dupilcateLinkCount = 0;
        for (MaltegoLink existingLink : linksBetweenEntity) {
            Object existingLinkValue;
            PropertyDescriptor pd;
            Object newLinkValue;
            boolean allPropertiesMatch = false;
            Iterator iterator = newLink.getProperties().iterator();
            while (iterator.hasNext() && (allPropertiesMatch = Utilities.compareObjects((Object)(newLinkValue = newLink.getValue(pd = (PropertyDescriptor)iterator.next())), (Object)(existingLinkValue = existingLink.getValue(pd))))) {
            }
            if (allPropertiesMatch) {
                ++dupilcateLinkCount;
                continue;
            }
            this.cache.addLinksBetweenEntities(mergedLinkEntityId, newLink);
        }
        return dupilcateLinkCount > 0;
    }
}

