/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config;

import com.paterva.maltego.java.config.jre.ExecutionResults;
import com.paterva.maltego.java.config.jre.FileProxy;
import com.paterva.maltego.java.config.jre.JavaInfo;
import com.paterva.maltego.java.config.jre.JavaUtils;
import com.paterva.maltego.java.config.jre.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MemorySelector {
    private static Map<String, MemorySelector> _selectors = new HashMap<String, MemorySelector>();
    private String _javaHome;
    private Integer _max;

    public static synchronized MemorySelector get(String javaHomeLocation) {
        MemorySelector selector = _selectors.get(javaHomeLocation);
        if (selector == null) {
            selector = new MemorySelector(javaHomeLocation);
            _selectors.put(javaHomeLocation, selector);
        }
        return selector;
    }

    private MemorySelector(String javaHomeLocation) {
        this._javaHome = javaHomeLocation;
    }

    public int getPrefered() {
        System.out.println("Detecting appropriate heap size...");
        int max = this.getMax();
        File windowsPipeline = new File("C:\\Users\\VssAdministrator");
        if (windowsPipeline.exists() && max > 7000) {
            System.out.println("Using adjustment factor of 0.7 instead of 0.8...");
            return (int)((double)max * 0.7);
        }
        return (int)((double)max * 0.8);
    }

    public int getMin() {
        return 64;
    }

    public int getMax() {
        if (this._max == null) {
            File executable = JavaUtils.getExecutable(new File(this._javaHome));
            File testJdk = FileProxy.getFile("resource:com/paterva/maltego/java/config/jre/TestJDK.class");
            if (testJdk == null) {
                this._max = this.getMin();
            } else {
                int closeEnough = 25;
                int min = 200;
                int max = 248000;
                int overhead = 300;
                int safetyMargin = 300;
                int working = min;
                int notWorking = this.getMaxHeapSize(min, max);
                if (!this.tryHeapSize(working, executable, testJdk)) {
                    this._max = this.getMin();
                } else {
                    while (notWorking - working > closeEnough) {
                        int mean = (working + notWorking) / 2;
                        System.out.print(mean + "...");
                        if (this.tryHeapSize(mean, executable, testJdk)) {
                            System.out.println("");
                            working = mean;
                            continue;
                        }
                        System.out.println(".");
                        notWorking = mean;
                    }
                    this._max = Math.max(Math.round((working - overhead - safetyMargin) / 100) * 100, min);
                }
            }
        }
        return this._max;
    }

    private boolean tryHeapSize(int heapSize, File executable, File testJdk) {
        boolean success = false;
        try {
            ExecutionResults results = SystemUtils.executeCommand(true, executable.getAbsolutePath(), "-Xmx" + heapSize + "m", "-classpath", testJdk.getParentFile().getAbsolutePath(), "TestJDK");
            JavaInfo jdkInfo = JavaInfo.getInfo(results.getStdOut(), true);
            if (jdkInfo != null) {
                success = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return success;
    }

    private int getMaxHeapSize(int minimum, int maximum) {
        long physicalMemorySize = -1L;
        try {
            File executable = JavaUtils.getExecutable(new File(this._javaHome));
            File testMem = FileProxy.getFile("resource:com/paterva/maltego/java/config/mem/TestMem.class");
            if (testMem != null) {
                ExecutionResults results = SystemUtils.executeCommand(true, executable.getAbsolutePath(), "-classpath", testMem.getParentFile().getAbsolutePath(), "TestMem");
                String err = results.getStdErr();
                if (err != null && err.length() > 0) {
                    System.out.println("err: " + err);
                }
                String memOut = results.getStdOut().split(System.getProperty("line.separator"))[0];
                System.out.println("memOut: " + memOut);
                physicalMemorySize = Long.parseLong(memOut);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int megs = (int)(physicalMemorySize / 0x100000L);
        int heapSize = Math.max(Math.min(megs, maximum), minimum);
        System.out.println("pm: " + heapSize + "/" + megs);
        return heapSize;
    }
}

