/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config;

import com.paterva.maltego.java.config.ConfigOptions;
import com.paterva.maltego.java.config.IPVersion;
import com.paterva.maltego.java.config.IPVersionSettings;
import com.paterva.maltego.java.config.MatteBorderLeft;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;

public class IPPanel
extends JPanel {
    private final AtomicBoolean _updating = new AtomicBoolean(false);
    private ChangeListener _changeListener;
    private ButtonGroup _addressesGroup;
    private JLabel _addressesLabel;
    private JRadioButton _ipv4Addresses;
    private JRadioButton _ipv4Stack;
    private JRadioButton _ipv6Addresses;
    private JRadioButton _ipv6Stack;
    private JCheckBox _managedCheckbox;
    private ButtonGroup _stackGroup;
    private JLabel _stackLabel;
    private JPanel jPanel1;

    public IPPanel() {
        this.initComponents();
        Font font = new JLabel().getFont().deriveFont(1);
        this._stackLabel.setFont(font);
        this._addressesLabel.setFont(font);
        IPSettingsListener ipSettingsListener = new IPSettingsListener();
        this._managedCheckbox.addActionListener(ipSettingsListener);
        this._ipv4Stack.addActionListener(ipSettingsListener);
        this._ipv6Stack.addActionListener(ipSettingsListener);
        this._ipv4Addresses.addActionListener(ipSettingsListener);
        this._ipv6Addresses.addActionListener(ipSettingsListener);
        this.updateJavaUserManagedState(false);
    }

    public void load(ConfigOptions options) {
        this._updating.set(true);
        IPVersionSettings ipVersionSettings = options.getIpVersionSettings();
        boolean managed = ipVersionSettings.isManaged();
        if (managed) {
            this.setIPJavaManaged();
        } else {
            this.setIPUserManaged();
        }
        this.setIPv4StackSelected(ipVersionSettings.getIPv4().isPrefer());
        this.setIPv6AddressesSelected(ipVersionSettings.getIPv6().isPrefer());
        this._updating.set(false);
        this.updateJavaUserManagedState(false);
        if (!managed) {
            this.updateIPStackState();
        }
    }

    public void store(ConfigOptions options) {
        options.setIpVersionSettings(this.getIPVersionSettings());
    }

    public IPVersionSettings getIPVersionSettings() {
        IPVersion ipv4 = IPVersion.getIPv4Stack();
        ipv4.setPrefer(this.isIPv4StackSelected());
        IPVersion ipv6 = IPVersion.getIPv6Addresses();
        ipv6.setPrefer(this.isIPv6AddressesSelected());
        IPVersionSettings ipVersionSettings = new IPVersionSettings(ipv4, ipv6);
        ipVersionSettings.setManaged(this.isIPJavaManaged());
        return ipVersionSettings;
    }

    public boolean valid() {
        return true;
    }

    boolean isIPJavaManaged() {
        return this._managedCheckbox.isSelected();
    }

    void setIPJavaManaged() {
        this._managedCheckbox.setSelected(true);
    }

    boolean isIPUserManaged() {
        return !this.isIPJavaManaged();
    }

    void setIPUserManaged() {
        this._managedCheckbox.setSelected(false);
    }

    boolean isIPv4StackEnabled() {
        return this._ipv4Stack.isEnabled();
    }

    boolean isIPv6AddressesEnabled() {
        return this._ipv6Addresses.isEnabled();
    }

    boolean isIPv4StackSelected() {
        return this._ipv4Stack.isSelected();
    }

    boolean isIPv6AddressesSelected() {
        return this._ipv6Addresses.isSelected();
    }

    JCheckBox getIPJavaManagedCheckbox() {
        return this._managedCheckbox;
    }

    JRadioButton getIPv4StackRadiobutton() {
        return this._ipv4Stack;
    }

    JRadioButton getIPv6StackRadiobutton() {
        return this._ipv6Stack;
    }

    void setIPv4StackSelected(boolean state) {
        if (state) {
            this._stackGroup.setSelected(this._ipv4Stack.getModel(), true);
        } else {
            this._stackGroup.setSelected(this._ipv6Stack.getModel(), true);
        }
    }

    void setIPv6AddressesSelected(boolean state) {
        if (state) {
            this._addressesGroup.setSelected(this._ipv6Addresses.getModel(), true);
        } else {
            this._addressesGroup.setSelected(this._ipv4Addresses.getModel(), true);
        }
    }

    private void updateJavaUserManagedState(boolean checkboxToggled) {
        boolean managed = this.isIPJavaManaged();
        this._stackLabel.setEnabled(!managed);
        this._ipv4Stack.setEnabled(!managed);
        this._ipv6Stack.setEnabled(!managed);
        this._addressesLabel.setEnabled(!managed);
        this._ipv4Addresses.setEnabled(!managed);
        this._ipv6Addresses.setEnabled(!managed);
        if (checkboxToggled) {
            if (managed) {
                this.setIPv4StackSelected(false);
                this.setIPv6AddressesSelected(false);
            } else {
                this.setIPv4StackSelected(false);
                this.setIPv6AddressesSelected(true);
            }
        }
    }

    private void updateIPStackState() {
        if (!this._updating.get()) {
            this._updating.set(true);
            boolean ipv4Stack = this.isIPv4StackSelected();
            if (ipv4Stack) {
                this._ipv6Addresses.setEnabled(false);
                this.setIPv6AddressesSelected(false);
            } else {
                this._ipv6Addresses.setEnabled(true);
            }
            this._updating.set(false);
        }
    }

    void setChangeListener(ChangeListener listener) {
        this._changeListener = listener;
    }

    private void initComponents() {
        this._stackGroup = new ButtonGroup();
        this._addressesGroup = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this._stackLabel = new JLabel();
        this._addressesLabel = new JLabel();
        this._managedCheckbox = new JCheckBox();
        this._ipv4Stack = new JRadioButton();
        this._ipv6Stack = new JRadioButton();
        this._ipv4Addresses = new JRadioButton();
        this._ipv6Addresses = new JRadioButton();
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), UIManager.getLookAndFeelDefaults().getColor("TitledBorder.darculaMod.matteBorderColor")), "Internet Protocol (IP)"), BorderFactory.createEmptyBorder(3, 10, 3, 10)));
        this.setLayout(new GridBagLayout());
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this._stackLabel.setText("Preferred stack:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.add((Component)this._stackLabel, gridBagConstraints);
        this._addressesLabel.setText("Preferred addresses:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.add((Component)this._addressesLabel, gridBagConstraints);
        this._managedCheckbox.setText("Let Java choose which IP version stack and addresses to use");
        this._managedCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IPPanel.this._managedCheckboxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this._managedCheckbox, gridBagConstraints);
        this._stackGroup.add(this._ipv4Stack);
        this._ipv4Stack.setText("IPv4");
        this._ipv4Stack.setToolTipText("Only support IPv4 addresses");
        this._ipv4Stack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IPPanel.this._ipv4StackActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        this.add((Component)this._ipv4Stack, gridBagConstraints);
        this._stackGroup.add(this._ipv6Stack);
        this._ipv6Stack.setText("IPv6");
        this._ipv6Stack.setToolTipText("Support IPv4 and IPv6 addresses");
        this._ipv6Stack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IPPanel.this._ipv6StackActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        this.add((Component)this._ipv6Stack, gridBagConstraints);
        this._addressesGroup.add(this._ipv4Addresses);
        this._ipv4Addresses.setText("IPv4");
        this._ipv4Addresses.setToolTipText("Prefer IPv4 addresses before IPv6 addresses");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        this.add((Component)this._ipv4Addresses, gridBagConstraints);
        this._addressesGroup.add(this._ipv6Addresses);
        this._ipv6Addresses.setText("IPv6");
        this._ipv6Addresses.setToolTipText("Prefer IPv6 addresses before IPv4 addresses");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        this.add((Component)this._ipv6Addresses, gridBagConstraints);
    }

    private void _managedCheckboxActionPerformed(ActionEvent evt) {
        if (!this._updating.get()) {
            this._updating.set(true);
            this.updateJavaUserManagedState(true);
            this._updating.set(false);
        }
    }

    private void _ipv4StackActionPerformed(ActionEvent evt) {
        this.updateIPStackState();
    }

    private void _ipv6StackActionPerformed(ActionEvent evt) {
        this.updateIPStackState();
    }

    private class IPSettingsListener
    implements ActionListener {
        private IPSettingsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (IPPanel.this._changeListener != null) {
                IPPanel.this._changeListener.stateChanged(null);
            }
        }
    }
}

