/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.transactions;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.EntityUpdate;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.LinkUpdate;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.ui.graph.transactions.GraphOperation;
import com.paterva.maltego.ui.graph.transactions.GraphTransaction;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import java.awt.Point;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GraphTransactions {
    private GraphTransactions() {
    }

    public static GraphTransaction addEntities(Collection<MaltegoEntity> entities, Map<String, Map<EntityID, Point>> centers, boolean pinned) {
        return new Add(entities, Collections.emptyMap(), centers, GraphTransactions.createIDBooleanMap(entities, pinned), false);
    }

    public static GraphTransaction addLinks(Map<MaltegoLink, LinkEntityIDs> links) {
        return new Add(Collections.emptySet(), links, Collections.emptyMap(), null, false);
    }

    public static GraphTransaction addEntitiesAndLinks(Collection<MaltegoEntity> entities, Map<MaltegoLink, LinkEntityIDs> links, Map<String, Map<EntityID, Point>> centers, boolean pinned, boolean needsLayout) {
        return new Add(entities, links, centers, GraphTransactions.createIDBooleanMap(entities, pinned), needsLayout);
    }

    public static GraphTransaction addEntitiesAndLinks(Collection<MaltegoEntity> entities, Map<MaltegoLink, LinkEntityIDs> links, Map<String, Map<EntityID, Point>> centers, Map<EntityID, Boolean> pinned, boolean needsLayout) {
        return new Add(entities, links, centers, pinned, needsLayout);
    }

    public static GraphTransaction deleteEntities(Set<EntityID> entityIDs) {
        return GraphTransactions.deleteEntitiesAndLinks(entityIDs, Collections.emptySet());
    }

    public static GraphTransaction deleteLinks(Set<LinkID> linkIDs) {
        return GraphTransactions.deleteEntitiesAndLinks(Collections.emptySet(), linkIDs);
    }

    public static GraphTransaction deleteEntitiesAndLinks(Set<EntityID> entityIDs, Set<LinkID> linkIDs) {
        Set<EntityUpdate> entityUpdates = GraphTransactionHelper.createEntityUpdatesIdsOnly(entityIDs);
        Set<LinkUpdate> linkUpdates = GraphTransactionHelper.createLinkUpdatesIdsOnly(linkIDs);
        return new Delete(entityUpdates, linkUpdates);
    }

    public static GraphTransaction updateAll(Collection<EntityUpdate> entityUpdates, Collection<LinkUpdate> linkUpdates, Map<String, Map<EntityID, Point>> centers, Map<String, Map<LinkID, List<Point>>> paths, Map<EntityID, Boolean> pinned) {
        return new Update(entityUpdates, linkUpdates, centers, paths, pinned);
    }

    public static GraphTransaction updateEntitiesAndLinks(Collection<EntityUpdate> entityUpdates, Collection<LinkUpdate> linkUpdates) {
        return GraphTransactions.updateEntitiesAndLinks(entityUpdates, linkUpdates, null);
    }

    public static GraphTransaction updateEntitiesAndLinks(Collection<EntityUpdate> entityUpdates, Collection<LinkUpdate> linkUpdates, Map<EntityID, Boolean> pinned) {
        return new Update(entityUpdates, linkUpdates, pinned);
    }

    public static GraphTransaction updateCentersAndPaths(Collection<EntityUpdate> entityUpdates, Collection<LinkUpdate> linkUpdates, Map<String, Map<EntityID, Point>> centers, Map<String, Map<LinkID, List<Point>>> paths) {
        return new Update(entityUpdates, linkUpdates, centers, paths, null);
    }

    public static GraphTransaction addProperties(Collection<EntityUpdate> entityUpdates, Collection<LinkUpdate> linkUpdates) {
        return new AddProperties(entityUpdates, linkUpdates);
    }

    public static GraphTransaction deleteProperties(Collection<EntityUpdate> entityUpdates, Collection<LinkUpdate> linkUpdates) {
        return new DeleteProperties(entityUpdates, linkUpdates);
    }

    public static GraphTransaction changeBookmark(Set<EntityID> entityIDs, int bookmark) {
        Set<EntityUpdate> entityUpdates = GraphTransactionHelper.createEntityUpdatesIdsOnly(entityIDs);
        for (MaltegoEntity maltegoEntity : entityUpdates) {
            maltegoEntity.setBookmark(Integer.valueOf(bookmark));
        }
        return new Update(entityUpdates, Collections.emptySet(), null);
    }

    public static GraphTransaction create(GraphOperation op, Collection<? extends MaltegoEntity> entities, Collection<? extends MaltegoLink> links, Map<String, Map<EntityID, Point>> centers, Map<String, Map<LinkID, List<Point>>> paths, Map<LinkID, LinkEntityIDs> linkEnities, Map<EntityID, Boolean> pinned, boolean needsLayout) {
        return new GraphTransactionImpl(op, entities, links, centers, paths, linkEnities, pinned, needsLayout);
    }

    private static Map<EntityID, Boolean> createIDBooleanMap(Collection<? extends MaltegoEntity> entities, boolean value) {
        HashMap<EntityID, Boolean> map = new HashMap<EntityID, Boolean>(entities.size());
        for (MaltegoEntity maltegoEntity : entities) {
            map.put((EntityID)maltegoEntity.getID(), value);
        }
        return map;
    }

    private static class GraphTransactionImpl
    implements GraphTransaction {
        private Map<EntityID, MaltegoEntity> _entities;
        private Map<LinkID, MaltegoLink> _links;
        private Map<String, Map<EntityID, Point>> _centers;
        private Map<String, Map<LinkID, List<Point>>> _paths;
        private Map<LinkID, LinkEntityIDs> _linkEntities;
        private boolean _needsLayout = false;
        private GraphOperation _operation;
        private Map<EntityID, Boolean> _pinned;

        public GraphTransactionImpl(GraphOperation op, Collection<? extends MaltegoEntity> entities, Map<? extends MaltegoLink, LinkEntityIDs> links, Map<String, Map<EntityID, Point>> centers, Map<String, Map<LinkID, List<Point>>> paths, Map<EntityID, Boolean> pinned, boolean needsLayout) {
            this(op, entities, links.keySet(), centers, paths, GraphTransactionHelper.convertLinksToGuids(links), pinned, needsLayout);
        }

        public GraphTransactionImpl(GraphOperation op, Collection<? extends MaltegoEntity> entities, Collection<? extends MaltegoLink> links, Map<EntityID, Boolean> pinned) {
            this(op, entities, links, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), pinned, false);
        }

        public GraphTransactionImpl(GraphOperation op, Collection<? extends MaltegoEntity> entities, Collection<? extends MaltegoLink> links, Map<String, Map<EntityID, Point>> centers, Map<String, Map<LinkID, List<Point>>> paths, Map<LinkID, LinkEntityIDs> linkEnities, Map<EntityID, Boolean> pinned, boolean needsLayout) {
            this._entities = this.toMap(entities);
            this._links = this.toMap(links);
            this._centers = centers;
            this._paths = paths;
            this._linkEntities = linkEnities;
            this._operation = op;
            this._pinned = pinned;
            this._needsLayout = needsLayout;
        }

        @Override
        public GraphOperation getOperation() {
            return this._operation;
        }

        @Override
        public Set<EntityID> getEntityIDs() {
            return Collections.unmodifiableSet(this._entities.keySet());
        }

        @Override
        public Set<String> getViews() {
            HashSet<String> views = new HashSet<String>();
            views.addAll(this._centers.keySet());
            views.addAll(this._paths.keySet());
            return views;
        }

        @Override
        public Point getCenter(String viewId, EntityID entityID) {
            Map<EntityID, Point> centers = this._centers.get(viewId);
            return centers != null ? centers.get(entityID) : null;
        }

        @Override
        public Set<LinkID> getLinkIDs() {
            return Collections.unmodifiableSet(this._links.keySet());
        }

        @Override
        public MaltegoEntity getSource(LinkID linkID) {
            EntityID sourceID = this.getSourceID(linkID);
            return sourceID == null ? null : this.getEntity(sourceID);
        }

        @Override
        public EntityID getSourceID(LinkID linkID) {
            LinkEntityIDs entities = this._linkEntities.get(linkID);
            return entities == null ? null : entities.getSourceID();
        }

        @Override
        public MaltegoEntity getTarget(LinkID linkID) {
            EntityID targetID = this.getTargetID(linkID);
            return targetID == null ? null : this.getEntity(targetID);
        }

        @Override
        public EntityID getTargetID(LinkID linkID) {
            LinkEntityIDs entities = this._linkEntities.get(linkID);
            return entities == null ? null : entities.getTargetID();
        }

        @Override
        public MaltegoEntity getEntity(EntityID entityID) {
            return this._entities.get(entityID);
        }

        @Override
        public MaltegoLink getLink(LinkID linkID) {
            return this._links.get(linkID);
        }

        @Override
        public List<Point> getPath(String viewId, LinkID linkID) {
            Map<LinkID, List<Point>> paths = this._paths.get(viewId);
            return paths != null ? paths.get(linkID) : null;
        }

        public void setNeedsLayout(boolean needsLayout) {
            this._needsLayout = needsLayout;
        }

        @Override
        public Map<EntityID, Boolean> getPinned() {
            return this._pinned == null ? null : Collections.unmodifiableMap(this._pinned);
        }

        @Override
        public boolean needsLayout() {
            return this._needsLayout;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" GraphTransaction (").append(this.getOperation().name()).append(")\n");
            if (this.needsLayout()) {
                sb.append("  (needs layout)").append("\n");
            }
            for (EntityID entityID : this.getEntityIDs()) {
                sb.append("  ").append(this.getEntity(entityID));
                for (String viewId : this.getViews()) {
                    sb.append("   ").append(viewId).append(":").append(this.getCenter(viewId, entityID)).append("\n");
                }
                if (this.getPinned() == null) continue;
                sb.append("   Pinned: ").append(this.getPinned().get(entityID)).append("\n");
            }
            for (LinkID linkID : this.getLinkIDs()) {
                sb.append("  ").append(this.getLink(linkID));
                MaltegoEntity source = this.getSource(linkID);
                MaltegoEntity target = this.getTarget(linkID);
                if (source != null && target != null) {
                    sb.append("   ").append(source.getID()).append("->").append(target.getID()).append("\n");
                }
                for (String viewId : this.getViews()) {
                    List<Point> path = this.getPath(viewId, linkID);
                    if (path == null) continue;
                    sb.append("   ").append(viewId).append(":");
                    for (Point point : path) {
                        sb.append(point);
                    }
                    sb.append("\n");
                }
            }
            return sb.toString();
        }

        private <ID extends Guid, Part extends MaltegoPart<ID>> Map<ID, Part> toMap(Collection<? extends Part> parts) {
            HashMap<Guid, MaltegoPart> map = new HashMap<Guid, MaltegoPart>(parts.size());
            for (MaltegoPart part : parts) {
                map.put(part.getID(), part);
            }
            return map;
        }
    }

    private static class DeleteProperties
    extends GraphTransactionImpl {
        public DeleteProperties(Collection<EntityUpdate> entities, Collection<LinkUpdate> links) {
            super(GraphOperation.DeleteProperties, entities, links, null);
        }
    }

    private static class AddProperties
    extends GraphTransactionImpl {
        public AddProperties(Collection<EntityUpdate> entities, Collection<LinkUpdate> links) {
            super(GraphOperation.AddProperties, entities, links, null);
        }
    }

    private static class Delete
    extends GraphTransactionImpl {
        public Delete(Collection<EntityUpdate> entities, Collection<LinkUpdate> links) {
            super(GraphOperation.Delete, entities, links, null);
        }
    }

    private static class Update
    extends GraphTransactionImpl {
        public Update(Collection<EntityUpdate> entities, Collection<LinkUpdate> links, Map<String, Map<EntityID, Point>> centers, Map<String, Map<LinkID, List<Point>>> paths, Map<EntityID, Boolean> pinned) {
            super(GraphOperation.Update, entities, links, centers, paths, Collections.emptyMap(), pinned, false);
        }

        public Update(Collection<EntityUpdate> entities, Collection<LinkUpdate> links, Map<EntityID, Boolean> pinned) {
            super(GraphOperation.Update, entities, links, pinned);
        }
    }

    private static class Add
    extends GraphTransactionImpl {
        public Add(Collection<MaltegoEntity> entities, Map<MaltegoLink, LinkEntityIDs> links, Map<String, Map<EntityID, Point>> centers, Map<EntityID, Boolean> pinned, boolean needsLayout) {
            super(GraphOperation.Add, entities, links, centers, Collections.emptyMap(), pinned, needsLayout);
        }
    }
}

