/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.imgfactory.parts.EntityImageFactory;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.editing.propertygrid.DisplayDescriptorProperty;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.ui.graph.actions.EditNodeAction;
import com.paterva.maltego.ui.graph.nodes.BulkQueryEntityCache;
import com.paterva.maltego.ui.graph.nodes.EntityNodeToEntitySpecConverter;
import com.paterva.maltego.ui.graph.nodes.EntityNodeToMaltegoEntityConverter;
import com.paterva.maltego.ui.graph.nodes.EntityProperties;
import com.paterva.maltego.ui.graph.nodes.NodeConverterKey;
import com.paterva.maltego.ui.graph.nodes.ProxyProperty;
import com.paterva.maltego.util.ImageCallback;
import java.awt.Image;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class EntityNode
extends AbstractNode
implements ImageCallback {
    private final BulkQueryEntityCache _entityCache;
    private GraphID _graphID;
    private EntityID _entityID;
    private boolean includeAttachmentProperty = true;

    public EntityNode(GraphID graphID, EntityID entityID, BulkQueryEntityCache entityCache) {
        this(graphID, entityID, entityCache, new InstanceContent());
    }

    public EntityNode(GraphID graphID, EntityID entityID, BulkQueryEntityCache entityCache, boolean includeAttachmentProperty) {
        this(graphID, entityID, entityCache, new InstanceContent());
        this.includeAttachmentProperty = includeAttachmentProperty;
    }

    private EntityNode(GraphID graphID, EntityID entityID, BulkQueryEntityCache entityCache, InstanceContent content) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this._entityCache = entityCache;
        if (graphID == null) {
            throw new IllegalArgumentException("Graph ID may not be null");
        }
        if (entityID == null) {
            throw new IllegalArgumentException("Entity ID may not be null");
        }
        try {
            GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
            if (view.getModelViewMappings().isOnlyViewEntity(entityID)) {
                throw new IllegalArgumentException("NetBeans nodes may only be created for model entities");
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        content.add((Object)graphID);
        content.add((Object)entityID);
        content.add(new NodeConverterKey<EntityNode>(this), (InstanceContent.Convertor)EntityNodeToMaltegoEntityConverter.instance());
        content.add(new NodeConverterKey<EntityNode>(this), (InstanceContent.Convertor)EntityNodeToEntitySpecConverter.instance());
        this._graphID = graphID;
        this._entityID = entityID;
        content.add((Object)new GraphEntity(this._graphID, this._entityID));
    }

    public EntityID getEntityID() {
        return this._entityID;
    }

    public Node.PropertySet[] getPropertySets() {
        Node.PropertySet[] propertySets = super.getPropertySets();
        if (!this.includeAttachmentProperty) {
            propertySets = this.filterAttachmentProperty(propertySets);
        }
        return propertySets;
    }

    private Node.PropertySet[] filterAttachmentProperty(Node.PropertySet[] propertySets) {
        for (int i = 0; i < propertySets.length; ++i) {
            Node.PropertySet ps = propertySets[i];
            Node.Property[] properties = ps.getProperties();
            if (properties.length == 0) continue;
            Node.Property[] temp = new Node.Property[properties.length - 1];
            int tempIndex = 0;
            boolean changeVal = false;
            for (Node.Property p : properties) {
                if (p instanceof ProxyProperty) {
                    Node.Property delegate = ((ProxyProperty)p).getDelegate();
                    if (delegate instanceof DisplayDescriptorProperty) {
                        DisplayDescriptorProperty ddp = (DisplayDescriptorProperty)delegate;
                        if (Attachments.class != ddp.getDisplayDescriptor().getType()) {
                            if (tempIndex + 1 > temp.length) continue;
                            temp[tempIndex++] = p;
                            continue;
                        }
                        changeVal = true;
                        continue;
                    }
                    if (tempIndex + 1 > temp.length) continue;
                    temp[tempIndex++] = p;
                    continue;
                }
                if (tempIndex + 1 > temp.length) continue;
                temp[tempIndex++] = p;
            }
            if (!changeVal) continue;
            Sheet.Set set = new Sheet.Set();
            set.put(temp);
            propertySets[i] = set;
        }
        return propertySets;
    }

    public Image getIcon(int type) {
        MaltegoEntity entity = this.getEntity();
        if (entity == null) {
            return super.getIcon(type);
        }
        return EntityImageFactory.forGraph((GraphID)this._graphID).getImage(entity, -1, this.getSize(type), (ImageCallback)this);
    }

    private EntityRegistry getRegistry() {
        return EntityRegistry.forGraphID((GraphID)this._graphID);
    }

    private int getSize(int type) {
        if (type == 1 || type == 3) {
            return 16;
        }
        return 32;
    }

    public String getDisplayName() {
        MaltegoEntity entity = this.getEntity();
        if (entity == null) {
            return "<removed>";
        }
        return InheritanceHelper.getDisplayString((SpecRegistry)this.getRegistry(), (TypedPropertyBag)entity);
    }

    public MaltegoEntity getEntity() {
        return this._entityCache.getEntity(this._entityID);
    }

    public MaltegoEntitySpec getEntitySpec() {
        MaltegoEntitySpec spec = null;
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(this._graphID);
            GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
            String type = dataReader.getEntityType(this._entityID);
            EntityRegistry registry = EntityRegistry.forGraphID((GraphID)this._graphID);
            spec = (MaltegoEntitySpec)registry.get(type);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return spec;
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public Action getPreferredAction() {
        return SystemAction.get(EditNodeAction.class);
    }

    public synchronized Action[] getActions(boolean popup) {
        return new Action[0];
    }

    protected Sheet createSheet() {
        MaltegoEntity entity = this.getEntity();
        if (entity != null) {
            MaltegoEntitySpec spec = this.getEntitySpec();
            return EntityProperties.createSheet(this._graphID, (Node)this, entity, spec);
        }
        return new Sheet();
    }

    public void imageReady(Image image) {
    }

    public String toString() {
        return InheritanceHelper.getDisplayString((SpecRegistry)this.getRegistry(), (TypedPropertyBag)this.getEntity());
    }
}

