/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.imex;

import com.ctc.wstx.stax.WstxOutputFactory;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.layout.GraphLayoutReader;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.ui.graph.EntityColorFactory;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.Version;
import com.sun.xml.txw2.output.IndentingXMLStreamWriter;
import java.awt.Color;
import java.awt.Point;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class GephiWriter {
    private Collection<EntityID> entityIDs;
    private XMLStreamWriter writer;
    private GraphDataStoreReader dataReader;
    private GraphStructureReader structureReader;
    private GraphLayoutReader layoutReader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(GraphID graphID, OutputStream os, boolean selectionOnly) throws Exception {
        this.writer = null;
        try {
            Set entities = selectionOnly ? GraphSelection.forGraph((GraphID)graphID).getSelectedModelEntities() : GraphStoreHelper.getEntityIDs((GraphID)graphID);
            this.initialize(graphID, entities);
            String encoding = StandardCharsets.UTF_8.name();
            WstxOutputFactory outputFactory = new WstxOutputFactory();
            outputFactory.configureForSpeed();
            XMLStreamWriter streamWriter = outputFactory.createXMLStreamWriter(os, encoding);
            this.writer = new IndentingXMLStreamWriter(streamWriter);
            this.writer.writeStartDocument(encoding, "1.0");
            this.writeGraphML();
            this.writer.writeEndDocument();
        }
        finally {
            if (this.writer != null) {
                try {
                    this.writer.close();
                    this.writer = null;
                }
                catch (XMLStreamException ex) {
                    NormalException.logStackTrace((Throwable)ex);
                }
            }
            this.uninitialize();
        }
    }

    private void initialize(GraphID graphID, Collection<EntityID> entities) throws GraphStoreException {
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
        this.dataReader = graphStore.getGraphDataStore().getDataStoreReader();
        this.structureReader = graphStore.getGraphStructureStore().getStructureReader();
        this.layoutReader = graphStore.getGraphLayoutStore().getLayoutReader();
        this.entityIDs = entities != null ? entities : this.getEntities();
    }

    private void uninitialize() {
        this.entityIDs = null;
        this.dataReader = null;
        this.layoutReader = null;
    }

    private void writeGraphML() throws Exception {
        this.writer.writeStartElement("graphml");
        this.writeNamespaceAttributes();
        this.writeVersion();
        this.writeKeys();
        this.writeGraph();
        this.writer.writeEndElement();
    }

    private void writeNamespaceAttributes() throws XMLStreamException {
        this.writer.writeDefaultNamespace("http://graphml.graphdrawing.org/xmlns");
    }

    private void writeVersion() throws XMLStreamException {
        Version version = Version.getCurrent();
        this.writer.writeComment("Created by " + version.toString(true, true, true));
    }

    private void writeKeys() throws XMLStreamException {
        this.writeKey("label", "node", "label", "string");
        this.writeKey("r", "node", "r", "int");
        this.writeKey("g", "node", "g", "int");
        this.writeKey("b", "node", "b", "int");
        this.writeKey("x", "node", "x", "float");
        this.writeKey("y", "node", "y", "float");
        this.writeKey("size", "node", "size", "float");
    }

    private void writeKey(String attrName, String fOr, String id, String yFilesType) throws XMLStreamException {
        this.writer.writeStartElement("key");
        if (attrName != null) {
            this.writer.writeAttribute("attr.name", attrName);
        }
        this.writer.writeAttribute("for", fOr);
        this.writer.writeAttribute("id", id);
        if (yFilesType != null) {
            this.writer.writeAttribute("yfiles.type", yFilesType);
        }
        this.writer.writeEndElement();
    }

    private void writeGraph() throws XMLStreamException, GraphStoreException {
        this.writer.writeStartElement("graph");
        this.writer.writeAttribute("edgedefault", "directed");
        int id = 0;
        HashMap<EntityID, Integer> nodeIDs = new HashMap<EntityID, Integer>(this.entityIDs.size());
        for (EntityID entityID : this.entityIDs) {
            this.writeNode(entityID, id);
            nodeIDs.put(entityID, id);
            ++id;
        }
        id = 0;
        Set<LinkID> linkIDs = this.getLinks();
        for (LinkID linkID : linkIDs) {
            this.writeEdge(linkID, id, nodeIDs);
            ++id;
        }
    }

    private void writeNode(EntityID entityID, int id) throws XMLStreamException, GraphStoreException {
        this.writeStartElement("node", "n" + id);
        this.writeNodeData(entityID);
        this.writeEndElement();
    }

    private void writeNodeData(EntityID entityID) throws XMLStreamException, GraphStoreException {
        MaltegoEntity entity = this.dataReader.getEntity(entityID);
        this.writeData("label", entity.getDisplayString());
        this.writeData("size", "40");
        Color color = EntityColorFactory.getDefault().getTypeColor(entity.getTypeName());
        this.writeData("r", Integer.toString(color.getRed()));
        this.writeData("g", Integer.toString(color.getGreen()));
        this.writeData("b", Integer.toString(color.getBlue()));
        Point center = this.layoutReader.getCenter(entityID);
        this.writeData("x", Double.toString(center.getX()));
        this.writeData("y", Double.toString(-center.getY()));
    }

    private void writeData(String key, String value) throws XMLStreamException {
        this.writer.writeStartElement("data");
        this.writer.writeAttribute("key", key);
        this.writer.writeCharacters(value);
        this.writer.writeEndElement();
    }

    private void writeEdge(LinkID linkID, int id, Map<EntityID, Integer> nodeIDs) throws XMLStreamException, GraphStoreException {
        this.writeStartElement("edge", "e" + id);
        this.writeSourceTargetAttributes(linkID, nodeIDs);
        this.writeEndElement();
    }

    private void writeSourceTargetAttributes(LinkID linkID, Map<EntityID, Integer> nodeIDs) throws GraphStoreException, XMLStreamException {
        LinkEntityIDs entities = this.structureReader.getEntities(linkID);
        this.writer.writeAttribute("source", "n" + nodeIDs.get(entities.getSourceID()));
        this.writer.writeAttribute("target", "n" + nodeIDs.get(entities.getTargetID()));
    }

    private void writeStartElement(String name, String id) throws XMLStreamException {
        this.writeStartElement(name, "id", id);
    }

    private void writeStartElement(String name, String attrName, String attrValue) throws XMLStreamException {
        this.writer.writeStartElement(name);
        this.writer.writeAttribute(attrName, attrValue);
    }

    private void writeEndElement() throws XMLStreamException {
        this.writer.writeEndElement();
    }

    private Set<LinkID> getLinks() throws GraphStoreException {
        return this.structureReader.getLinksBetween(this.entityIDs);
    }

    private Set<EntityID> getEntities() throws GraphStoreException {
        return this.structureReader.getEntities();
    }
}

