/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.archive.mtz.GraphFileType;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.util.HtmlUtils;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.TopComponent;

public abstract class OpenTemplateAction
extends CallableSystemAction {
    protected abstract String getTemplate();

    protected abstract String getName(String var1);

    protected abstract GraphFileType getFileType();

    public OpenTemplateAction() {
        this.putProperty("noIconInMenu", Boolean.TRUE);
    }

    public void performAction() {
        try {
            DataObject gdo = this.getDataObject();
            if (gdo instanceof GraphDataObject) {
                ((GraphDataObject)gdo).setFileType(this.getFileType());
            }
            OpenCookie cookie = (OpenCookie)gdo.getCookie(OpenCookie.class);
            cookie.open();
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    protected DataObject getDataObject() throws DataObjectNotFoundException, IOException {
        FileSystem memFS;
        FileObject root;
        DataFolder dataFolder;
        String templateName = this.getTemplate();
        FileObject fo = FileUtil.getConfigRoot().getFileObject(templateName);
        if (fo == null) {
            throw new IOException("The template '" + templateName + "' was not found.");
        }
        DataObject template = DataObject.find((FileObject)fo);
        DataObject gdo = template.createFromTemplate(dataFolder = DataFolder.findFolder((FileObject)(root = (memFS = FileUtil.createMemoryFileSystem()).getRoot())), this.getName(templateName) + " (" + OpenTemplateAction.getNextCount() + ")");
        if (gdo instanceof GraphDataObject) {
            ((GraphDataObject)gdo).setNew(true);
        }
        return gdo;
    }

    private static int getNextCount() {
        Set<TopComponent> open = GraphEditorRegistry.getDefault().getOpen();
        if (!open.isEmpty()) {
            TreeSet<Integer> openUnnamedGraphs = new TreeSet<Integer>();
            for (TopComponent topComponent : open) {
                String displayName = HtmlUtils.removeSkeleton((String)topComponent.getHtmlDisplayName());
                if (!displayName.matches("(<b>)?New Graph \\([0-9]*\\)(| \\*)(</b>)?")) continue;
                openUnnamedGraphs.add(Integer.parseInt(displayName.substring(displayName.indexOf("(") + 1, displayName.lastIndexOf(")"))));
            }
            if (!openUnnamedGraphs.isEmpty()) {
                int nextCount = 1;
                for (Integer graphIndex : openUnnamedGraphs) {
                    if (graphIndex != nextCount) {
                        return nextCount;
                    }
                    ++nextCount;
                }
                return nextCount;
            }
        }
        return 1;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }
}

