/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.GraphFactory;
import com.paterva.maltego.graph.store.copy.GraphCopier;
import com.paterva.maltego.graph.store.copy.GraphCopyContext;
import com.paterva.maltego.graph.store.copy.GraphCopyFactory;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.util.SlownessDetector;
import java.util.Set;

public class GraphCopyHelper {
    private GraphCopyHelper() {
    }

    public static void copy(GraphID srcGraphID, GraphID destGraphID) throws GraphStoreException {
        GraphCopyContext copyCtx = GraphCopyHelper.createCopyContext2(srcGraphID, destGraphID, null, null, true);
        GraphCopyHelper.copy(copyCtx);
    }

    public static GraphID copy(GraphID srcGraphID) throws GraphStoreException {
        return GraphCopyHelper.copy(srcGraphID, true);
    }

    public static GraphID copy(GraphID srcGraphID, boolean inMemory) throws GraphStoreException {
        return GraphCopyHelper.copy(srcGraphID, null, true, inMemory);
    }

    public static void copy(GraphID srcGraphID, Set<EntityID> entities, GraphID destGraphID) throws GraphStoreException {
        GraphCopyContext copyCtx = GraphCopyHelper.createCopyContext2(srcGraphID, destGraphID, entities, null, true);
        GraphCopyHelper.copy(copyCtx);
    }

    public static GraphID copy(GraphID srcGraphID, Set<EntityID> entities, boolean withLinks, boolean inMemory) throws GraphStoreException {
        return GraphCopyHelper.copy(srcGraphID, entities, null, withLinks, inMemory);
    }

    public static GraphID copy(GraphID srcGraphID, Set<EntityID> entities, Set<LinkID> links) throws GraphStoreException {
        return GraphCopyHelper.copy(srcGraphID, entities, links, false, true);
    }

    public static GraphID copy(GraphID srcGraphID, Set<EntityID> entities, Set<LinkID> links, boolean withLinks, boolean inMemory) throws GraphStoreException {
        GraphID destGraphID = GraphCopyHelper.createDestGraph(inMemory);
        GraphCopyContext copyCtx = GraphCopyHelper.createCopyContext2(srcGraphID, destGraphID, entities, links, withLinks);
        GraphCopyHelper.copy(copyCtx);
        return destGraphID;
    }

    public static void copy(GraphCopyContext copyCtx) throws GraphStoreException {
        try {
            SlownessDetector.setEnabled((boolean)false);
            GraphCopier graphCopier = GraphCopyFactory.getDefault().create();
            graphCopier.copy(copyCtx);
        }
        finally {
            SlownessDetector.setEnabled((boolean)true);
        }
    }

    private static GraphID createDestGraph(boolean inMemory) throws GraphStoreException {
        return GraphFactory.getDefault().createGraph(inMemory, true);
    }

    private static GraphCopyContext createCopyContext2(GraphID srcGraphID, GraphID destGraphID, Set<EntityID> entities, Set<LinkID> links, boolean withLinks) throws GraphStoreException {
        GraphCopyContext copyCtx = new GraphCopyContext(srcGraphID, destGraphID, entities, links, withLinks);
        return copyCtx;
    }
}

