/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkFactory;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.wrapper.GraphStoreWriter;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class GraphBuilder {
    private final GraphID _graphID;
    private Color _defaultLinkColor;
    private Integer _defaultLinkStyle;

    public GraphBuilder(GraphID graphID) {
        this._graphID = graphID;
    }

    public MaltegoEntity addEntity(String type) throws TypeInstantiationException {
        MaltegoEntity entity = (MaltegoEntity)EntityFactory.getDefault().createInstance(type, false, true);
        GraphStoreWriter.addEntity((GraphID)this._graphID, (MaltegoEntity)entity);
        return entity;
    }

    public MaltegoEntity addEntity(String type, String value) throws TypeInstantiationException {
        MaltegoEntity entity = this.addEntity(type);
        InheritanceHelper.setValue((SpecRegistry)EntityRegistry.forGraphID((GraphID)this._graphID), (TypedPropertyBag)entity, (Object)value);
        return entity;
    }

    public MaltegoLink connect(MaltegoEntity from, MaltegoEntity to) {
        MaltegoLink link = LinkFactory.forGraphID((GraphID)this._graphID).createInstance("maltego.link.manual-link", true);
        link.setColor(this._defaultLinkColor);
        link.setStyle(this._defaultLinkStyle);
        GraphStoreWriter.addLink((GraphID)this._graphID, (MaltegoLink)link, (LinkEntityIDs)new LinkEntityIDs((EntityID)from.getID(), (EntityID)to.getID()));
        return link;
    }

    public void setProperty(MaltegoLink link, String name, Object value) {
        this.setProperty(link, name, name, value);
    }

    public void setProperty(MaltegoLink link, String name, String displayName, Object value) {
        this.setProperty((MaltegoPart<? extends Guid>)link, (SpecRegistry<? extends TypeSpec>)LinkRegistry.forGraphID((GraphID)this._graphID), name, displayName, value);
    }

    public void setProperty(MaltegoEntity entity, String name, Object value) {
        this.setProperty(entity, name, name, value);
    }

    public void setProperty(MaltegoEntity entity, String name, String displayName, Object value) {
        this.setProperty((MaltegoPart<? extends Guid>)entity, (SpecRegistry<? extends TypeSpec>)EntityRegistry.forGraphID((GraphID)this._graphID), name, displayName, value);
    }

    private void setProperty(MaltegoPart<? extends Guid> part, SpecRegistry<? extends TypeSpec> registry, String name, String displayName, Object value) {
        DisplayDescriptorCollection descriptors = InheritanceHelper.getAggregatedProperties(registry, (String)part.getTypeName());
        DisplayDescriptor dd = descriptors.get(name);
        if (dd == null) {
            dd = new PropertyDescriptor(value.getClass(), name, displayName);
        }
        part.setValue((PropertyDescriptor)dd, value);
    }

    public Collection<MaltegoLink> connect(MaltegoEntity from, Iterable<MaltegoEntity> to) {
        return this.connect(Collections.singleton(from), to);
    }

    public Collection<MaltegoLink> connect(Iterable<MaltegoEntity> from, MaltegoEntity to) {
        return this.connect(from, Collections.singleton(to));
    }

    public Collection<MaltegoLink> connect(Iterable<MaltegoEntity> from, Iterable<MaltegoEntity> to) {
        ArrayList<MaltegoLink> links = new ArrayList<MaltegoLink>();
        for (MaltegoEntity f : from) {
            for (MaltegoEntity t : to) {
                links.add(this.connect(f, t));
            }
        }
        return links;
    }

    public Color getDefaultLinkColor() {
        return this._defaultLinkColor;
    }

    public void setDefaultLinkColor(Color defaultLinkColor) {
        this._defaultLinkColor = defaultLinkColor;
    }

    public Integer getDefaultLinkStyle() {
        return this._defaultLinkStyle;
    }

    public void setDefaultLinkStyle(Integer defaultLinkStyle) {
        this._defaultLinkStyle = defaultLinkStyle;
    }
}

