/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository;

import com.paterva.maltego.transform.descriptor.Popup;
import com.paterva.maltego.transform.descriptor.TransformSettings;
import com.paterva.maltego.transform.descriptor.Visibility;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.ListMap;
import com.paterva.maltego.util.StringUtilities;
import java.util.Map;

public class ListMapTransformSettings
implements TransformSettings {
    private boolean _enabled = true;
    private ListMap<String, TransformPropertySetting> _map;
    private boolean _accepted = false;
    private boolean _showHelp = true;
    private boolean _dirty = true;
    private boolean _runWithAll = true;
    private boolean _favorite = false;

    private Map<String, TransformPropertySetting> map() {
        if (this._map == null) {
            this._map = new ListMap();
        }
        return this._map;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void markClean() {
        this._dirty = false;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean value) {
        if (this._enabled != value) {
            this._enabled = value;
            this._dirty = true;
        }
    }

    public boolean isDisclaimerAccepted() {
        return this._accepted;
    }

    public void setDisclaimerAccepted(boolean value) {
        if (this._accepted != value) {
            this._accepted = value;
            this._dirty = true;
        }
    }

    public Popup getPopup(PropertyDescriptor descriptor) {
        return this.isPopup(descriptor.getName());
    }

    public Popup isPopup(String name) {
        TransformPropertySetting setting = this.map().get(name);
        if (setting == null) {
            return Popup.NotSet;
        }
        return setting.popup;
    }

    public void setPopup(PropertyDescriptor descriptor, Popup value) {
        this.setPopup(descriptor.getName(), value);
    }

    public void setPopup(String name, Popup value) {
        TransformPropertySetting setting = this.getOrMakeSetting(name);
        if (setting.popup != value) {
            setting.popup = value;
            this._dirty = true;
        }
    }

    public Object getValue(String name) {
        TransformPropertySetting setting = this.map().get(name);
        if (setting == null) {
            return null;
        }
        return setting.value;
    }

    public void setValue(String name, Object value) {
        TransformPropertySetting setting = this.getOrMakeSetting(name);
        if (setting.value == null || !setting.value.equals(value)) {
            setting.value = StringUtilities.isNullString((Object)value) ? null : value;
            this._dirty = true;
        }
    }

    public Object getValue(PropertyDescriptor descriptor) {
        return this.getValue(descriptor.getName());
    }

    public void setValue(PropertyDescriptor descriptor, Object value) {
        this.setValue(descriptor.getName(), value);
    }

    public void clear() {
        this.map().clear();
        this._dirty = true;
    }

    public boolean showHelp() {
        return this._showHelp;
    }

    public void setShowHelp(boolean value) {
        if (value != this._showHelp) {
            this._showHelp = value;
            this._dirty = true;
        }
    }

    public Visibility getVisibility(PropertyDescriptor descriptor) {
        TransformPropertySetting setting = this.map().get(descriptor.getName());
        if (setting != null && setting.visibility != null) {
            return setting.visibility;
        }
        return Visibility.Public;
    }

    public void setVisibility(PropertyDescriptor descriptor, Visibility mode) {
        this.setVisibility(descriptor.getName(), mode);
    }

    public void setVisibility(String name, Visibility mode) {
        TransformPropertySetting setting = this.getOrMakeSetting(name);
        if (setting.visibility != mode) {
            setting.visibility = mode;
            this._dirty = true;
        }
    }

    private TransformPropertySetting getOrMakeSetting(String name) {
        TransformPropertySetting setting = this.map().get(name);
        if (setting == null) {
            setting = new TransformPropertySetting();
            this.map().put(name, setting);
            this._dirty = true;
        }
        return setting;
    }

    public boolean isRunWithAll() {
        return this._runWithAll;
    }

    public void setRunWithAll(boolean runWithAll) {
        if (this._runWithAll != runWithAll) {
            this._runWithAll = runWithAll;
            this._dirty = true;
        }
    }

    public boolean isFavorite() {
        return this._favorite;
    }

    public void setFavorite(boolean favorite) {
        if (this._favorite != favorite) {
            this._favorite = favorite;
            this._dirty = true;
        }
    }

    private class TransformPropertySetting {
        public Popup popup = Popup.NotSet;
        public Object value = null;
        public Visibility visibility = Visibility.Public;

        private TransformPropertySetting() {
        }
    }
}

