/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.runviews.favs;

import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ui.GraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class FavoritesIcon
implements Icon {
    private final int iconSize = IconSize.TINY.getSize();

    @Override
    public int getIconWidth() {
        return this.iconSize;
    }

    @Override
    public int getIconHeight() {
        return this.iconSize;
    }

    protected void draw(Graphics2D g2D, int h, Component c) {
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        Color color1 = laf.getColor("run-favorites-icon-color1");
        Color color2 = laf.getColor("run-favorites-icon-color2");
        GraphicsUtils.drawShadedFatPentagram((Graphics2D)g2D, (int)0, (int)0, (int)h, (int)h, (Color)color1, (Color)color2);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int xPos, int yPos) {
        if (g instanceof Graphics2D) {
            Graphics2D g2D = (Graphics2D)g;
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            AffineTransform oldTransform = g2D.getTransform();
            double scale = 0.1f;
            g2D.scale(scale, scale);
            int x = (int)((double)xPos / scale);
            int y = (int)((double)yPos / scale);
            int h = (int)((double)this.getIconHeight() / scale);
            g2D.translate(x, y);
            this.draw(g2D, h, c);
            g2D.setTransform(oldTransform);
        }
    }
}

