/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.customicons.manage;

import com.paterva.maltego.customicons.manage.IconNameController;
import com.paterva.maltego.customicons.manage.IconNameDisplayPanel;
import com.paterva.maltego.imgfactory.icons.IconExistInfo;
import com.paterva.maltego.imgfactory.icons.IconLayerRegistry;
import com.paterva.maltego.imgfactoryapi.IconRegistry;
import com.paterva.maltego.imgfactoryapi.RegistryIcon;
import com.paterva.maltego.importexport.ImportAction;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ui.components.ScrollablePanel;
import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import com.paterva.maltego.util.ui.dialog.EditDialogDisplayer;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.lang3.StringUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class IconDetailsPanel
extends JPanel {
    private final IconExistInfo _existInfo = new IconExistInfo();
    private RegistryIcon _icon;
    private JButton _16ChangeButton;
    private JLabel _16icon;
    private JLabel _16label;
    private JButton _24ChangeButton;
    private JLabel _24icon;
    private JLabel _24label;
    private JButton _32ChangeButton;
    private JLabel _32icon;
    private JLabel _32label;
    private JButton _48ChangeButton;
    private JLabel _48icon;
    private JLabel _48label;
    private JButton _96ChangeButton;
    private JLabel _96icon;
    private JLabel _96label;
    private JButton _addAliasButton;
    private JPanel _detailsPanel;
    private JScrollPane _detailsScrollPane;
    private IconNameDisplayPanel _displayNamePanel;
    private JPanel _iconSizes;
    private JPanel _pad;
    private ScrollablePanel _scrollablePanel;
    private JLabel jLabel2;
    private JPanel jPanel4;

    public IconDetailsPanel() {
        this.initComponents();
        this._scrollablePanel.setScrollableWidth(ScrollablePanel.ScrollableSizeHint.FIT);
        this._scrollablePanel.setScrollableHeight(ScrollablePanel.ScrollableSizeHint.NONE);
        this._16icon.setText("");
        this._24icon.setText("");
        this._32icon.setText("");
        this._48icon.setText("");
        this._96icon.setText("");
        this.update();
    }

    public void setIcon(RegistryIcon icon) {
        this._icon = icon;
        this._displayNamePanel.setIcon(icon, null);
        this.update();
    }

    private void update() {
        CardLayout layout = (CardLayout)this.getLayout();
        if (this._icon == null) {
            layout.show(this, "Empty");
        } else {
            layout.show(this, "Details");
            boolean isReadOnly = this._existInfo.isReadOnly(this._icon);
            this.syncNameAliasPanels(isReadOnly);
            this._displayNamePanel.setEnabled(!isReadOnly);
            this._addAliasButton.setEnabled(!isReadOnly);
            this._16icon.setIcon(this.getIcon(IconSize.TINY.getSize()));
            this._24icon.setIcon(this.getIcon(IconSize.SMALL.getSize()));
            this._32icon.setIcon(this.getIcon(IconSize.MEDIUM.getSize()));
            this._48icon.setIcon(this.getIcon(IconSize.LARGE.getSize()));
            this._96icon.setIcon(this.getIcon(IconSize.MASSIVE.getSize()));
            this._16ChangeButton.setEnabled(!isReadOnly);
            this._24ChangeButton.setEnabled(!isReadOnly);
            this._32ChangeButton.setEnabled(!isReadOnly);
            this._48ChangeButton.setEnabled(!isReadOnly);
            this._96ChangeButton.setEnabled(!isReadOnly);
            this.revalidate();
            this.repaint();
        }
    }

    private void syncNameAliasPanels(boolean isReadOnly) {
        for (Component component : this._detailsPanel.getComponents()) {
            if (!(component instanceof IconNameDisplayPanel)) continue;
            this._detailsPanel.remove(component);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        this._detailsPanel.add((Component)this._displayNamePanel, gbc);
        Set iconAliases = this._icon.getAliases();
        for (String alias : iconAliases) {
            ++gbc.gridy;
            this.insertAliasPanel(this._icon, alias, gbc, isReadOnly);
        }
        ++gbc.gridy;
        GridBagLayout gbl = (GridBagLayout)this._detailsPanel.getLayout();
        for (Component component : this._detailsPanel.getComponents()) {
            if (component instanceof IconNameDisplayPanel) continue;
            GridBagConstraints constraints = gbl.getConstraints(component);
            constraints.gridy = gbc.gridy + constraints.gridy - 1;
            gbl.setConstraints(component, constraints);
        }
    }

    private void insertAliasPanel(RegistryIcon icon, String aliasName, GridBagConstraints gbc, boolean isReadOnly) {
        IconNameDisplayPanel aliasPanel = new IconNameDisplayPanel();
        aliasPanel.setIcon(icon, aliasName);
        aliasPanel.setEnabled(!isReadOnly);
        this._detailsPanel.add((Component)aliasPanel, gbc);
    }

    private Icon getIcon(int size) {
        Optional imgOpt;
        if (this._icon != null && (imgOpt = IconRegistry.getDefault().loadImage(this._icon, IconSize.getSize((int)size))).isPresent()) {
            return new ImageIcon((Image)imgOpt.get());
        }
        return null;
    }

    private void changeIcon(IconSize size) {
        FileChooserBuilder builder = new FileChooserBuilder(ImportAction.class);
        builder.setApproveText("Select Image");
        builder.setFilesOnly(true);
        builder.setTitle("Select image");
        File file = builder.showOpenDialog();
        if (file != null) {
            BufferedImage img = this.loadImage(file);
            if (img == null) {
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)"Not a valid image file.");
                nd.setTitle("Invalid Image");
                nd.setMessageType(2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            } else {
                try {
                    IconLayerRegistry.getDefault().replace(this._icon, size, img);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private BufferedImage loadImage(File file) {
        try {
            return ImageIO.read(file);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private void initComponents() {
        this._detailsScrollPane = new JScrollPane();
        this._scrollablePanel = new ScrollablePanel();
        this._detailsPanel = new JPanel();
        this._pad = new JPanel();
        this._iconSizes = new JPanel();
        this._24label = new JLabel();
        this._96label = new JLabel();
        this._32label = new JLabel();
        this._16label = new JLabel();
        this._16ChangeButton = new JButton();
        this._24ChangeButton = new JButton();
        this._32ChangeButton = new JButton();
        this._96ChangeButton = new JButton();
        this._24icon = new JLabel();
        this._96icon = new JLabel();
        this._32icon = new JLabel();
        this._16icon = new JLabel();
        this._48label = new JLabel();
        this._48ChangeButton = new JButton();
        this._48icon = new JLabel();
        this._displayNamePanel = new IconNameDisplayPanel();
        this._addAliasButton = new JButton();
        this.jPanel4 = new JPanel();
        this.jLabel2 = new JLabel();
        this.setLayout(new CardLayout());
        this._detailsScrollPane.setMinimumSize(new Dimension(280, 100));
        this._scrollablePanel.setLayout((LayoutManager)new BorderLayout());
        this._detailsPanel.setLayout(new GridBagLayout());
        GroupLayout _padLayout = new GroupLayout(this._pad);
        this._pad.setLayout(_padLayout);
        _padLayout.setHorizontalGroup(_padLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 320, Short.MAX_VALUE));
        _padLayout.setVerticalGroup(_padLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1, Short.MAX_VALUE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this._detailsPanel.add((Component)this._pad, gridBagConstraints);
        this._iconSizes.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this._24label, (String)NbBundle.getMessage(IconDetailsPanel.class, (String)"IconDetailsPanel._24label.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this._iconSizes.add((Component)this._24label, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this._96label, (String)NbBundle.getMessage(IconDetailsPanel.class, (String)"IconDetailsPanel._96label.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this._iconSizes.add((Component)this._96label, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this._32label, (String)NbBundle.getMessage(IconDetailsPanel.class, (String)"IconDetailsPanel._32label.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this._iconSizes.add((Component)this._32label, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this._16label, (String)NbBundle.getMessage(IconDetailsPanel.class, (String)"IconDetailsPanel._16label.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this._iconSizes.add((Component)this._16label, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._16ChangeButton, (String)NbBundle.getMessage(IconDetailsPanel.class, (String)"IconDetailsPanel._16ChangeButton.text"));
        this._16ChangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IconDetailsPanel.this._16ChangeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 0);
        this._iconSizes.add((Component)this._16ChangeButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._24ChangeButton, (String)NbBundle.getMessage(IconDetailsPanel.class, (String)"IconDetailsPanel._24ChangeButton.text"));
        this._24ChangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IconDetailsPanel.this._24ChangeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 0);
        this._iconSizes.add((Component)this._24ChangeButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._32ChangeButton, (String)NbBundle.getMessage(IconDetailsPanel.class, (String)"IconDetailsPanel._32ChangeButton.text"));
        this._32ChangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IconDetailsPanel.this._32ChangeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 0);
        this._iconSizes.add((Component)this._32ChangeButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._96ChangeButton, (String)NbBundle.getMessage(IconDetailsPanel.class, (String)"IconDetailsPanel._96ChangeButton.text"));
        this._96ChangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IconDetailsPanel.this._96ChangeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 0);
        this._iconSizes.add((Component)this._96ChangeButton, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this._24icon, (String)NbBundle.getMessage(IconDetailsPanel.class, (String)"IconDetailsPanel._24icon.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this._iconSizes.add((Component)this._24icon, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this._96icon, (String)NbBundle.getMessage(IconDetailsPanel.class, (String)"IconDetailsPanel._96icon.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this._iconSizes.add((Component)this._96icon, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this._32icon, (String)NbBundle.getMessage(IconDetailsPanel.class, (String)"IconDetailsPanel._32icon.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this._iconSizes.add((Component)this._32icon, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this._16icon, (String)NbBundle.getMessage(IconDetailsPanel.class, (String)"IconDetailsPanel._16icon.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this._iconSizes.add((Component)this._16icon, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this._48label, (String)NbBundle.getMessage(IconDetailsPanel.class, (String)"IconDetailsPanel._48label.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this._iconSizes.add((Component)this._48label, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this._48ChangeButton, (String)NbBundle.getMessage(IconDetailsPanel.class, (String)"IconDetailsPanel._48ChangeButton.text"));
        this._48ChangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IconDetailsPanel.this._48ChangeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 0);
        this._iconSizes.add((Component)this._48ChangeButton, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this._48icon, (String)NbBundle.getMessage(IconDetailsPanel.class, (String)"IconDetailsPanel._48icon.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this._iconSizes.add((Component)this._48icon, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this._detailsPanel.add((Component)this._iconSizes, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this._detailsPanel.add((Component)this._displayNamePanel, gridBagConstraints);
        this._addAliasButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/customicons/resources/Add.png")));
        Mnemonics.setLocalizedText((AbstractButton)this._addAliasButton, (String)NbBundle.getMessage(IconDetailsPanel.class, (String)"IconDetailsPanel._addAliasButton.text"));
        this._addAliasButton.setToolTipText(NbBundle.getMessage(IconDetailsPanel.class, (String)"IconDetailsPanel._addAliasButton.toolTipText"));
        this._addAliasButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IconDetailsPanel.this._addAliasButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 6, 6, 0);
        this._detailsPanel.add((Component)this._addAliasButton, gridBagConstraints);
        this._scrollablePanel.add((Component)this._detailsPanel, (Object)"Center");
        this._detailsScrollPane.setViewportView((Component)this._scrollablePanel);
        this.add((Component)this._detailsScrollPane, "Details");
        this.jPanel4.setLayout(new BorderLayout());
        this.jLabel2.setForeground(new Color(153, 153, 153));
        this.jLabel2.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(IconDetailsPanel.class, (String)"IconDetailsPanel.jLabel2.text"));
        this.jPanel4.add((Component)this.jLabel2, "Center");
        this.add((Component)this.jPanel4, "Empty");
    }

    private void _16ChangeButtonActionPerformed(ActionEvent evt) {
        this.changeIcon(IconSize.TINY);
    }

    private void _24ChangeButtonActionPerformed(ActionEvent evt) {
        this.changeIcon(IconSize.SMALL);
    }

    private void _32ChangeButtonActionPerformed(ActionEvent evt) {
        this.changeIcon(IconSize.MEDIUM);
    }

    private void _96ChangeButtonActionPerformed(ActionEvent evt) {
        this.changeIcon(IconSize.MASSIVE);
    }

    private void _48ChangeButtonActionPerformed(ActionEvent evt) {
        this.changeIcon(IconSize.LARGE);
    }

    private void _addAliasButtonActionPerformed(ActionEvent evt) {
        String alias;
        IconNameController controller = new IconNameController("Alias ", true);
        EditDialogDescriptor descriptor = new EditDialogDescriptor((WizardDescriptor.Panel)controller);
        descriptor.putProperty("iconCategory", (Object)this._icon.getCategory());
        descriptor.putProperty("iconName", (Object)"");
        if (EditDialogDescriptor.OK_OPTION.equals(EditDialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor)) && StringUtils.isNotBlank((CharSequence)(alias = (String)descriptor.getProperty("iconName")))) {
            try {
                IconRegistry.getDefault().addAlias(this._icon, alias.trim());
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

