/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.tabular.transforms.run;

import com.paterva.maltego.tabular.transforms.run.AbstractTabularTransformRunner;
import com.paterva.maltego.tabular.transforms.run.TabularTransformRunner;
import com.paterva.maltego.tabular.transforms.run.TabularTransformSearchRunner;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.gen.TransformSource;
import com.paterva.maltego.transform.gen.TransformSourceRegistry;
import com.paterva.maltego.transform.runner.api.AbstractTransformAdapter;
import com.paterva.maltego.transform.runner.api.MatchingRuleUpdater;
import com.paterva.maltego.transform.runner.api.TransformDoneMutex;
import com.paterva.maltego.transform.runner.api.TransformRunContext;
import com.paterva.maltego.transforms.tabular.TabularTransformSourceRepository;
import com.paterva.maltego.transforms.tabular.TabularTransformType;
import com.paterva.maltego.transforms.tabular.data.TabularTransform;
import com.paterva.maltego.transforms.tabular.data.TabularTransformSource;
import com.paterva.maltego.util.Args;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.openide.util.Cancellable;

public class TabularTransformAdapter
extends AbstractTransformAdapter {
    protected List<Cancellable> runAsync(TransformRunContext context) throws Exception {
        AbstractTabularTransformRunner runner;
        Args.notNull((Object)context, (String)"context");
        TransformDefinition transform = context.getTransform();
        if (TabularTransformType.isGlobalSearch((TransformDescriptor)transform)) {
            List sources = TabularTransformSourceRepository.getInstance().getAll();
            runner = new TabularTransformSearchRunner(context, (MatchingRuleUpdater)this, sources);
        } else {
            Optional searchTransformSource = TabularTransformType.getSearchTransformSource((TransformDescriptor)transform);
            if (searchTransformSource.isPresent()) {
                List<TabularTransformSource> sources = Collections.singletonList(searchTransformSource.get());
                runner = new TabularTransformSearchRunner(context, (MatchingRuleUpdater)this, sources);
            } else {
                SourceAndTransform sourceAndTransform = this.getSourceAndTransform(transform);
                TabularTransformSource source = sourceAndTransform.getSource();
                TabularTransform tabularTransform = sourceAndTransform.getTransform();
                runner = new TabularTransformRunner(context, (MatchingRuleUpdater)this, source, tabularTransform);
            }
        }
        return Collections.singletonList(runner.run(this.getDoneMutex()));
    }

    public void cancel() {
        TransformDoneMutex mutex = this.getDoneMutex();
        if (mutex != null) {
            mutex.cancel();
        }
    }

    private SourceAndTransform getSourceAndTransform(TransformDefinition transform) {
        Args.notNull((Object)transform, (String)"transform");
        String transformName = transform.getName();
        for (TransformSource ds : TransformSourceRegistry.getInstance().getAll()) {
            TabularTransformSource tds = (TabularTransformSource)ds;
            Optional tabularTx = tds.getTabularTransform(transformName);
            if (!tabularTx.isPresent()) continue;
            return new SourceAndTransform(tds, (TabularTransform)tabularTx.get());
        }
        throw new IllegalArgumentException("Tabular source and transform not found: " + transform.getDisplayName());
    }

    protected boolean applyAdvancedProperties() {
        return true;
    }

    private static class SourceAndTransform {
        private final TabularTransformSource source;
        private final TabularTransform transform;

        public SourceAndTransform(TabularTransformSource source, TabularTransform transform) {
            Args.notNull((Object)source, (String)"source");
            Args.notNull((Object)transform, (String)"transform");
            this.source = source;
            this.transform = transform;
        }

        public TabularTransformSource getSource() {
            return this.source;
        }

        public TabularTransform getTransform() {
            return this.transform;
        }
    }
}

