/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import edu.umass.cs.benchlab.har.HarCache;
import edu.umass.cs.benchlab.har.HarContent;
import edu.umass.cs.benchlab.har.HarCookie;
import edu.umass.cs.benchlab.har.HarCookies;
import edu.umass.cs.benchlab.har.HarCreator;
import edu.umass.cs.benchlab.har.HarCustomFields;
import edu.umass.cs.benchlab.har.HarEntry;
import edu.umass.cs.benchlab.har.HarEntryTimings;
import edu.umass.cs.benchlab.har.HarHeader;
import edu.umass.cs.benchlab.har.HarHeaders;
import edu.umass.cs.benchlab.har.HarLog;
import edu.umass.cs.benchlab.har.HarPostData;
import edu.umass.cs.benchlab.har.HarPostDataParam;
import edu.umass.cs.benchlab.har.HarPostDataParams;
import edu.umass.cs.benchlab.har.HarQueryParam;
import edu.umass.cs.benchlab.har.HarQueryString;
import edu.umass.cs.benchlab.har.HarRequest;
import edu.umass.cs.benchlab.har.HarResponse;
import edu.umass.cs.benchlab.har.tools.HarFileWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpCookie;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpHeader;
import org.parosproxy.paros.network.HttpHeaderField;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.HttpResponseHeader;
import org.zaproxy.zap.network.HttpRequestBody;

public final class HarUtils {
    private static final Logger LOGGER = LogManager.getLogger(HarUtils.class);
    public static final String CUSTOM_FIELD_PREFIX = "_zap";
    public static final String MESSAGE_ID_CUSTOM_FIELD = "_zapMessageId";
    public static final String MESSAGE_TYPE_CUSTOM_FIELD = "_zapMessageType";
    public static final String MESSAGE_NOTE_CUSTOM_FIELD = "_zapMessageNote";

    private HarUtils() {
    }

    public static HarLog createZapHarLog() {
        return new HarLog(new HarCreator("ZAP", Constant.PROGRAM_VERSION));
    }

    public static byte[] harLogToByteArray(HarLog harLog) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        HarFileWriter w = new HarFileWriter();
        w.writeHarFile(harLog, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static HttpMessage createHttpMessage(String jsonHarRequest) throws IOException {
        return HarUtils.createHttpMessage(HarUtils.createHarRequest(jsonHarRequest));
    }

    public static HarRequest createHarRequest(String jsonHarRequest) throws IOException {
        HarRequest harRequest;
        try (JsonParser jp = new JsonFactory().createJsonParser(jsonHarRequest);){
            jp.nextToken();
            jp.nextToken();
            harRequest = new HarRequest(jp, null);
        }
        return harRequest;
    }

    public static HttpMessage createHttpMessage(HarRequest harRequest) throws HttpMalformedHeaderException {
        StringBuilder strBuilderReqHeader = new StringBuilder();
        strBuilderReqHeader.append(harRequest.getMethod()).append(' ').append(harRequest.getUrl()).append(' ').append(harRequest.getHttpVersion()).append("\r\n");
        for (HarHeader harHeader : harRequest.getHeaders().getHeaders()) {
            strBuilderReqHeader.append(harHeader.getName()).append(": ").append(harHeader.getValue()).append("\r\n");
        }
        strBuilderReqHeader.append("\r\n");
        StringBuilder strBuilderReqBody = new StringBuilder();
        HarPostData harPostData = harRequest.getPostData();
        if (harPostData != null) {
            String text = harPostData.getText();
            if (text != null && !text.isEmpty()) {
                strBuilderReqBody.append(harRequest.getPostData().getText());
            } else if (harPostData.getParams() != null && !harPostData.getParams().getPostDataParams().isEmpty()) {
                for (HarPostDataParam param : harRequest.getPostData().getParams().getPostDataParams()) {
                    if (strBuilderReqBody.length() > 0) {
                        strBuilderReqBody.append('&');
                    }
                    strBuilderReqBody.append(param.getName()).append('=').append(param.getValue());
                }
            }
        }
        return new HttpMessage(new HttpRequestHeader(strBuilderReqHeader.toString()), new HttpRequestBody(strBuilderReqBody.toString()));
    }

    public static HarEntry createHarEntry(HttpMessage httpMessage) {
        HarEntryTimings timings = new HarEntryTimings(0L, 0L, (long)httpMessage.getTimeElapsedMillis());
        return new HarEntry(new Date(httpMessage.getTimeSentMillis()), (long)httpMessage.getTimeElapsedMillis(), HarUtils.createHarRequest(httpMessage), HarUtils.createHarResponse(httpMessage), new HarCache(), timings);
    }

    public static HarEntry createHarEntry(int historyId, int historyType, HttpMessage httpMessage) {
        HarEntry entry = HarUtils.createHarEntry(httpMessage);
        entry.setCustomFields(HarUtils.createMessageHarCustomFields(historyId, historyType, httpMessage.getNote()));
        return entry;
    }

    public static HarCustomFields createMessageHarCustomFields(int historyId, int historyType, String messageNote) {
        HarCustomFields customFields = new HarCustomFields();
        customFields.addCustomField(MESSAGE_ID_CUSTOM_FIELD, Integer.toString(historyId));
        customFields.addCustomField(MESSAGE_TYPE_CUSTOM_FIELD, Integer.toString(historyType));
        customFields.addCustomField(MESSAGE_NOTE_CUSTOM_FIELD, messageNote);
        return customFields;
    }

    /*
     * WARNING - void declaration
     */
    public static HarRequest createHarRequest(HttpMessage httpMessage) {
        void var4_9;
        HttpRequestHeader requestHeader = httpMessage.getRequestHeader();
        HarCookies harCookies = new HarCookies();
        try {
            for (HttpCookie httpCookie : requestHeader.getHttpCookies()) {
                harCookies.addCookie(new HarCookie(httpCookie.getName(), httpCookie.getValue()));
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Ignoring cookies for HAR (\"request\") \"cookies\" list. Request contains invalid cookie: {}", (Object)e.getMessage());
        }
        HarQueryString harQueryString = new HarQueryString();
        for (HtmlParameter param : httpMessage.getUrlParams()) {
            harQueryString.addQueryParam(new HarQueryParam(param.getName(), param.getValue()));
        }
        Object var4_7 = null;
        HttpRequestBody requestBody = httpMessage.getRequestBody();
        if (requestBody.length() >= 0) {
            HarPostDataParams params = new HarPostDataParams();
            String text = "";
            String contentType = requestHeader.getHeader("content-type");
            if (contentType == null) {
                contentType = "";
                text = requestBody.toString();
            } else if (StringUtils.startsWithIgnoreCase((CharSequence)contentType.trim(), (CharSequence)"application/x-www-form-urlencoded")) {
                for (HtmlParameter param : httpMessage.getFormParams()) {
                    params.addPostDataParam(new HarPostDataParam(param.getName(), param.getValue()));
                }
            } else {
                text = requestBody.toString();
            }
            HarPostData harPostData = new HarPostData(contentType, params, text, null);
        }
        return new HarRequest(requestHeader.getMethod(), requestHeader.getURI().toString(), requestHeader.getVersion(), harCookies, HarUtils.createHarHeaders(requestHeader), harQueryString, (HarPostData)var4_9, (long)requestHeader.toString().length(), (long)httpMessage.getRequestBody().length(), null);
    }

    public static HarResponse createHarResponse(HttpMessage httpMessage) {
        HttpResponseHeader responseHeader = httpMessage.getResponseHeader();
        HarCookies harCookies = new HarCookies();
        long whenCreated = System.currentTimeMillis();
        for (HttpCookie cookie : responseHeader.getHttpCookies(httpMessage.getRequestHeader().getHostName())) {
            Date expires = cookie.getVersion() == 0 ? new Date(whenCreated + cookie.getMaxAge() * 1000L) : new Date(httpMessage.getTimeSentMillis() + (long)httpMessage.getTimeElapsedMillis() + cookie.getMaxAge() * 1000L);
            harCookies.addCookie(new HarCookie(cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), expires, cookie.isHttpOnly(), cookie.getSecure(), null));
        }
        String text = null;
        String encoding = null;
        String contentType = responseHeader.getHeader("content-type");
        if (contentType == null) {
            contentType = "";
        } else if (!contentType.isEmpty()) {
            String lcContentType = contentType.toLowerCase(Locale.ROOT);
            int pos = lcContentType.indexOf(59);
            if (pos != -1) {
                lcContentType = lcContentType.substring(0, pos).trim();
            }
            if (!lcContentType.startsWith("text")) {
                encoding = "base64";
                text = Base64.getEncoder().encodeToString(httpMessage.getResponseBody().getBytes());
            } else {
                text = httpMessage.getResponseBody().toString();
            }
        }
        HarContent harContent = new HarContent((long)httpMessage.getResponseBody().length(), 0L, contentType, text, encoding, null);
        String redirectUrl = responseHeader.getHeader("location");
        return new HarResponse(responseHeader.getStatusCode(), responseHeader.getReasonPhrase(), responseHeader.getVersion(), harCookies, HarUtils.createHarHeaders(responseHeader), harContent, redirectUrl == null ? "" : redirectUrl, (long)responseHeader.toString().length(), (long)httpMessage.getResponseBody().length(), null);
    }

    public static HarHeaders createHarHeaders(HttpHeader httpHeader) {
        HarHeaders harHeaders = new HarHeaders();
        List<HttpHeaderField> headers = httpHeader.getHeaders();
        for (HttpHeaderField headerField : headers) {
            harHeaders.addHeader(new HarHeader(headerField.getName(), headerField.getValue()));
        }
        return harHeaders;
    }
}

