% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_direction.R
\name{p_direction.lm}
\alias{p_direction.lm}
\title{Probability of Direction (pd)}
\usage{
\method{p_direction}{lm}(
  x,
  ci = 0.95,
  method = "direct",
  null = 0,
  vcov = NULL,
  vcov_args = NULL,
  ...
)
}
\arguments{
\item{x}{A statistical model.}

\item{ci}{Confidence Interval (CI) level. Default to \code{0.95} (\verb{95\%}).}

\item{method}{Can be \code{"direct"} or one of methods of \code{\link[bayestestR:estimate_density]{estimate_density()}},
such as \code{"kernel"}, \code{"logspline"} or \code{"KernSmooth"}. See details.}

\item{null}{The value considered as a "null" effect. Traditionally 0, but
could also be 1 in the case of ratios of change (OR, IRR, ...).}

\item{vcov}{Variance-covariance matrix used to compute uncertainty estimates
(e.g., for robust standard errors). This argument accepts a covariance
matrix, a function which returns a covariance matrix, or a string which
identifies the function to be used to compute the covariance matrix.
\itemize{
\item A covariance matrix
\item A function which returns a covariance matrix (e.g., \code{stats::vcov()})
\item A string which indicates the kind of uncertainty estimates to return.
\itemize{
\item Heteroskedasticity-consistent: \code{"HC"}, \code{"HC0"}, \code{"HC1"}, \code{"HC2"},
\code{"HC3"}, \code{"HC4"}, \code{"HC4m"}, \code{"HC5"}. See \code{?sandwich::vcovHC}
\item Cluster-robust: \code{"CR"}, \code{"CR0"}, \code{"CR1"}, \code{"CR1p"}, \code{"CR1S"},
\code{"CR2"}, \code{"CR3"}. See \code{?clubSandwich::vcovCR}
\item Bootstrap: \code{"BS"}, \code{"xy"}, \code{"residual"}, \code{"wild"}, \code{"mammen"},
\code{"fractional"}, \code{"jackknife"}, \code{"norm"}, \code{"webb"}. See
\code{?sandwich::vcovBS}
\item Other \code{sandwich} package functions: \code{"HAC"}, \code{"PC"}, \code{"CL"}, \code{"OPG"},
\code{"PL"}.
}
}}

\item{vcov_args}{List of arguments to be passed to the function identified by
the \code{vcov} argument. This function is typically supplied by the
\strong{sandwich} or \strong{clubSandwich} packages. Please refer to their
documentation (e.g., \code{?sandwich::vcovHAC}) to see the list of available
arguments. If no estimation type (argument \code{type}) is given, the default
type for \code{"HC"} equals the default from the \strong{sandwich} package; for type
\code{"CR"}, the default is set to \code{"CR3"}.}

\item{...}{Arguments passed to other methods, e.g. \code{ci()}. Arguments like
\code{vcov} or \code{vcov_args} can be used to compute confidence intervals using a
specific variance-covariance matrix for the standard errors.}
}
\value{
A data frame.
}
\description{
Compute the \strong{Probability of Direction} (\emph{pd}, also known as
the Maximum Probability of Effect - \emph{MPE}). This can be interpreted as the
probability that a parameter (described by its full confidence, or
"compatibility" interval) is strictly positive or negative (whichever is the
most probable). Although differently expressed, this index is fairly similar
(i.e., is strongly correlated) to the frequentist \emph{p-value} (see 'Details').
}
\section{What is the \emph{pd}?}{



The Probability of Direction (pd) is an index of effect existence, representing
the certainty with which an effect goes in a particular direction (i.e., is
positive or negative / has a sign), typically ranging from 0.5 to 1 (but see
next section for cases where it can range between 0 and 1). Beyond
its simplicity of interpretation, understanding and computation, this index
also presents other interesting properties:
\itemize{
\item Like other posterior-based indices, \emph{pd} is solely based on the posterior
distributions and does not require any additional information from the data
or the model (e.g., such as priors, as in the case of Bayes factors).
\item It is robust to the scale of both the response variable and the predictors.
\item It is strongly correlated with the frequentist p-value, and can thus
be used to draw parallels and give some reference to readers non-familiar
with Bayesian statistics (Makowski et al., 2019).
}

}

\section{Relationship with the p-value}{



In most cases, it seems that the \emph{pd} has a direct correspondence with the
frequentist one-sided \emph{p}-value through the formula (for two-sided \emph{p}):
\ifelse{html}{\out{p = 2 * (1 - p<sub>d</sub>)}}{\eqn{p = 2 \times (1 - p_d)}}
Thus, a two-sided p-value of respectively \code{.1}, \code{.05}, \code{.01} and \code{.001} would
correspond approximately to a \emph{pd} of \verb{95\%}, \verb{97.5\%}, \verb{99.5\%} and \verb{99.95\%}.
See \code{\link[bayestestR:pd_to_p]{pd_to_p()}} for details.

}

\section{Possible Range of Values}{



The largest value \emph{pd} can take is 1 - the posterior is strictly directional.
However, the smallest value \emph{pd} can take depends on the parameter space
represented by the posterior.

\strong{For a continuous parameter space}, exact values of 0 (or any point null
value) are not possible, and so 100\% of the posterior has \emph{some} sign, some
positive, some negative. Therefore, the smallest the \emph{pd} can be is 0.5 -
with an equal posterior mass of positive and negative values. Values close to
0.5 \emph{cannot} be used to support the null hypothesis (that the parameter does
\emph{not} have a direction) is a similar why to how large p-values cannot be used
to support the null hypothesis (see \code{\link[bayestestR:pd_to_p]{pd_to_p()}}; Makowski et al., 2019).

\strong{For a discrete parameter space or a parameter space that is a mixture
between discrete and continuous spaces}, exact values of 0 (or any point
null value) \emph{are} possible! Therefore, the smallest the \emph{pd} can be is 0 -
with 100\% of the posterior mass on 0. Thus values close to 0 can be used to
support the null hypothesis (see van den Bergh et al., 2021).

Examples of posteriors representing discrete parameter space:
\itemize{
\item When a parameter can only take discrete values.
\item When a mixture prior/posterior is used (such as the spike-and-slab prior;
see van den Bergh et al., 2021).
\item When conducting Bayesian model averaging (e.g., \code{\link[bayestestR:weighted_posteriors]{weighted_posteriors()}} or
\code{brms::posterior_average}).
}

}

\section{Statistical inference - how to quantify evidence}{

There is no standardized approach to drawing conclusions based on the
available data and statistical models. A frequently chosen but also much
criticized approach is to evaluate results based on their statistical
significance (\emph{Amrhein et al. 2017}).

A more sophisticated way would be to test whether estimated effects exceed
the "smallest effect size of interest", to avoid even the smallest effects
being considered relevant simply because they are statistically significant,
but clinically or practically irrelevant (\emph{Lakens et al. 2018, Lakens 2024}).

A rather unconventional approach, which is nevertheless advocated by various
authors, is to interpret results from classical regression models either in
terms of probabilities, similar to the usual approach in Bayesian statistics
(\emph{Schweder 2018; Schweder and Hjort 2003; Vos 2022}) or in terms of relative
measure of "evidence" or "compatibility" with the data (\emph{Greenland et al. 2022;
Rafi and Greenland 2020}), which nevertheless comes close to a probabilistic
interpretation.

A more detailed discussion of this topic is found in the documentation of
\code{\link[=p_function]{p_function()}}.

The \strong{parameters} package provides several options or functions to aid
statistical inference. These are, for example:
\itemize{
\item \code{\link[=equivalence_test.lm]{equivalence_test()}}, to compute the (conditional)
equivalence test for frequentist models
\item \code{\link[=p_significance.lm]{p_significance()}}, to compute the probability of
\emph{practical significance}, which can be conceptualized as a unidirectional
equivalence test
\item \code{\link[=p_function]{p_function()}}, or \emph{consonance function}, to compute p-values and
compatibility (confidence) intervals for statistical models
\item the \code{pd} argument (setting \code{pd = TRUE}) in \code{model_parameters()} includes
a column with the \emph{probability of direction}, i.e. the probability that a
parameter is strictly positive or negative. See \code{\link[bayestestR:p_direction]{bayestestR::p_direction()}}
for details. If plotting is desired, the \code{\link[=p_direction.lm]{p_direction()}}
function can be used, together with \code{plot()}.
\item the \code{s_value} argument (setting \code{s_value = TRUE}) in \code{model_parameters()}
replaces the p-values with their related \emph{S}-values (\emph{Rafi and Greenland 2020})
\item finally, it is possible to generate distributions of model coefficients by
generating bootstrap-samples (setting \code{bootstrap = TRUE}) or simulating
draws from model coefficients using \code{\link[=simulate_model]{simulate_model()}}. These samples
can then be treated as "posterior samples" and used in many functions from
the \strong{bayestestR} package.
}

Most of the above shown options or functions derive from methods originally
implemented for Bayesian models (\emph{Makowski et al. 2019}). However, assuming
that model assumptions are met (which means, the model fits well to the data,
the correct model is chosen that reflects the data generating process
(distributional model family) etc.), it seems appropriate to interpret
results from classical frequentist models in a "Bayesian way" (more details:
documentation in \code{\link[=p_function]{p_function()}}).
}

\examples{
\dontshow{if (requireNamespace("bayestestR") && require("see", quietly = TRUE) && requireNamespace("sandwich")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(qol_cancer)
model <- lm(QoL ~ time + age + education, data = qol_cancer)
p_direction(model)

# based on heteroscedasticity-robust standard errors
p_direction(model, vcov = "HC3")

result <- p_direction(model)
plot(result)
\dontshow{\}) # examplesIf}
}
\references{
\itemize{
\item Amrhein, V., Korner-Nievergelt, F., and Roth, T. (2017). The earth is
flat (p > 0.05): Significance thresholds and the crisis of unreplicable
research. PeerJ, 5, e3544. \doi{10.7717/peerj.3544}
\item Greenland S, Rafi Z, Matthews R, Higgs M. To Aid Scientific Inference,
Emphasize Unconditional Compatibility Descriptions of Statistics. (2022)
https://arxiv.org/abs/1909.08583v7 (Accessed November 10, 2022)
\item Lakens, D. (2024). Improving Your Statistical Inferences (Version v1.5.1).
Retrieved from https://lakens.github.io/statistical_inferences/.
\doi{10.5281/ZENODO.6409077}
\item Lakens, D., Scheel, A. M., and Isager, P. M. (2018). Equivalence Testing
for Psychological Research: A Tutorial. Advances in Methods and Practices
in Psychological Science, 1(2), 259–269. \doi{10.1177/2515245918770963}
\item Makowski, D., Ben-Shachar, M. S., Chen, S. H. A., and Lüdecke, D. (2019).
Indices of Effect Existence and Significance in the Bayesian Framework.
Frontiers in Psychology, 10, 2767. \doi{10.3389/fpsyg.2019.02767}
\item Rafi Z, Greenland S. Semantic and cognitive tools to aid statistical
science: replace confidence and significance by compatibility and surprise.
BMC Medical Research Methodology (2020) 20:244.
\item Schweder T. Confidence is epistemic probability for empirical science.
Journal of Statistical Planning and Inference (2018) 195:116–125.
\doi{10.1016/j.jspi.2017.09.016}
\item Schweder T, Hjort NL. Frequentist analogues of priors and posteriors.
In Stigum, B. (ed.), Econometrics and the Philosophy of Economics: Theory
Data Confrontation in Economics, pp. 285-217. Princeton University Press,
Princeton, NJ, 2003
\item Vos P, Holbert D. Frequentist statistical inference without repeated sampling.
Synthese 200, 89 (2022). \doi{10.1007/s11229-022-03560-x}
}
}
\seealso{
See also \code{\link[=equivalence_test]{equivalence_test()}}, \code{\link[=p_function]{p_function()}} and
\code{\link[=p_significance]{p_significance()}} for functions related to checking effect existence and
significance.
}
