% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth-flow-token-exchange.R
\name{req_oauth_token_exchange}
\alias{req_oauth_token_exchange}
\alias{oauth_flow_token_exchange}
\title{OAuth token exchange}
\usage{
req_oauth_token_exchange(
  req,
  client,
  subject_token,
  subject_token_type,
  resource = NULL,
  audience = NULL,
  scope = NULL,
  requested_token_type = NULL,
  actor_token = NULL,
  actor_token_type = NULL,
  token_params = list()
)

oauth_flow_token_exchange(
  client,
  subject_token,
  subject_token_type,
  resource = NULL,
  audience = NULL,
  scope = NULL,
  requested_token_type = NULL,
  actor_token = NULL,
  actor_token_type = NULL,
  token_params = list()
)
}
\arguments{
\item{req}{A httr2 \link{request} object.}

\item{client}{An \code{\link[=oauth_client]{oauth_client()}}.}

\item{subject_token}{The security token to exchange. This is usually an
OpenID Connect ID token or a SAML2 assertion.}

\item{subject_token_type}{A URI that describes the type of the security
token. Usually one of the options in \href{https://datatracker.ietf.org/doc/html/rfc8693#section-3}{Section 3 of RFC 8693}.}

\item{resource}{The URI that identifies the resource that the client is
trying to access, if applicable.}

\item{audience}{The logical name that identifies the resource that the client
is trying to access, if applicable. Usually one of \code{resource} or \code{audience}
must be supplied.}

\item{scope}{Scopes to be requested from the resource owner.}

\item{requested_token_type}{An optional URI that describes the type of the
security token being requested. Usually one of the options in
\href{https://datatracker.ietf.org/doc/html/rfc8693#section-3}{Section 3 of RFC 8693}.}

\item{actor_token}{An optional security token that represents the client,
rather than the identity behind the subject token.}

\item{actor_token_type}{When \code{actor_token} is not \code{NULL}, this must be the
URI that describes the type of the security token being requested. Usually
one of the options in \href{https://datatracker.ietf.org/doc/html/rfc8693#section-3}{Section 3 of RFC 8693}.}

\item{token_params}{List containing additional parameters passed to the
\code{token_url}.}
}
\value{
\code{req_oauth_token_exchange()} returns a modified HTTP \link{request} that
will exchange one security token for another; \code{oauth_flow_token_exchange()}
returns the resulting \link{oauth_token} directly.
}
\description{
Authenticate by exchanging one security token for another, as defined by
\href{https://datatracker.ietf.org/doc/html/rfc8693#section-2}{Section 2 of RFC 8693}. It is typically used for advanced authorization flows that
involve "delegation" or "impersonation" semantics, such as when a client
accesses a resource on behalf of another party, or when a client's identity
is federated from another provider.

Learn more about the overall OAuth authentication flow in
\url{https://httr2.r-lib.org/articles/oauth.html}.
}
\examples{
# List Google Cloud storage buckets using an OIDC token obtained
# from e.g. Microsoft Entra ID or Okta and federated to Google. (A real
# project ID and workforce pool would be required for this in practice.)
#
# See: https://cloud.google.com/iam/docs/workforce-obtaining-short-lived-credentials
oidc_token <- "an ID token from Okta"
request("https://storage.googleapis.com/storage/v1/b?project=123456") |>
  req_oauth_token_exchange(
    client = oauth_client("gcp", "https://sts.googleapis.com/v1/token"),
    subject_token = oidc_token,
    subject_token_type = "urn:ietf:params:oauth:token-type:id_token",
    scope = "https://www.googleapis.com/auth/cloud-platform",
    requested_token_type = "urn:ietf:params:oauth:token-type:access_token",
    audience = "//iam.googleapis.com/locations/global/workforcePools/123/providers/456",
    token_params = list(
      options = '{"userProject":"123456"}'
    )
  )
}
\seealso{
Other OAuth flows: 
\code{\link{req_oauth_auth_code}()},
\code{\link{req_oauth_bearer_jwt}()},
\code{\link{req_oauth_client_credentials}()},
\code{\link{req_oauth_password}()},
\code{\link{req_oauth_refresh}()}
}
\concept{OAuth flows}
