% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{InputArrayParam-class}
\alias{InputArrayParam-class}
\alias{InputArrayParam}
\alias{InputParam-class}
\alias{InputParam}
\alias{InputParamList-class}
\alias{InputParamList}
\alias{OutputArrayParam-class}
\alias{OutputArrayParam}
\alias{OutputParam-class}
\alias{OutputParam}
\alias{OutputParamList-class}
\alias{OutputParamList}
\alias{cwlProcess-class}
\alias{stepInParam-class}
\alias{stepInParam}
\alias{stepInParamList-class}
\alias{stepInParamList}
\alias{cwlStep-class}
\alias{cwlStepList-class}
\alias{cwlStepList}
\alias{cwlWorkflow-class}
\title{All classes defined in the package of `Rcwl` and the class constructor functions.}
\usage{
InputArrayParam(
  label = "",
  doc = character(),
  name = character(),
  type = "array",
  items = character(),
  prefix = "",
  separate = TRUE,
  itemSeparator = character(),
  valueFrom = character()
)

InputParam(
  id,
  label = "",
  type = "string",
  doc = character(),
  secondaryFiles = character(),
  streamable = logical(),
  format = character(),
  loadListing = character(),
  loadContents = logical(),
  position = 0L,
  prefix = "",
  separate = TRUE,
  itemSeparator = character(),
  valueFrom = character(),
  shellQuote = logical(),
  default = character(),
  value = character()
)

InputParamList(...)

OutputArrayParam(
  label = character(),
  doc = character(),
  name = character(),
  type = "array",
  items = character()
)

OutputParam(
  id = "output",
  label = character(),
  doc = character(),
  type = "stdout",
  format = character(),
  secondaryFiles = character(),
  streamable = logical(),
  glob = character(),
  loadContents = logical(),
  loadListing = character(),
  outputEval = character(),
  outputSource = character(),
  linkMerge = character(),
  pickValue = character()
)

OutputParamList(out = OutputParam(), ...)

stepInParam(
  id,
  source = character(),
  linkMerge = character(),
  pickValue = character(),
  loadContents = logical(),
  loadListing = character(),
  default = character(),
  valueFrom = character()
)

stepInParamList(...)

cwlStepList(...)
}
\arguments{
\item{label}{A short, human-readable label of this object.}

\item{doc}{A documentation string for this object, or an array of
strings which should be concatenated.}

\item{name}{The identifier for this type.}

\item{type}{Specify valid types of data that may be assigned to
this parameter.}

\item{items}{Defines the type of the array elements.}

\item{prefix}{Command line prefix to add before the value.}

\item{separate}{If true (default), then the prefix and value must
be added as separate command line arguments; if false, prefix
and value must be concatenated into a single command line
argument.}

\item{itemSeparator}{Join the array elements into a single string
with the elements separated by by itemSeparator.}

\item{valueFrom}{value from string or expression.}

\item{id}{A unique identifier for this workflow input parameter.}

\item{secondaryFiles}{Provides a pattern or expression specifying
files or directories. Only valid when type: File or is an array
of items: File.}

\item{streamable}{A value of true indicates that the file is read
or written sequentially without seeking. Only valid when type:
File or is an array of items: File.}

\item{format}{Only valid when type: File or is an array of items:
File. This is the file format that will be assigned to the
output File object.}

\item{loadListing}{Only valid when type: Directory or is an array
of items: Directory. "no_listing", "shallow_listing" or
"deep_listing".}

\item{loadContents}{Only valid when type: File or is an array of
items: File.}

\item{position}{The position for this parameter.}

\item{shellQuote}{If ShellCommandRequirement is in the requirements
for the current command, this controls whether the value is
quoted on the command line (default is true).}

\item{default}{The default value for this parameter to use if
either there is no source field, or the value produced by the
source is null.}

\item{value}{Assigned value for this parameter}

\item{...}{A list of `cwlStep` objects.}

\item{glob}{Pattern to find files relative to the output directory.}

\item{outputEval}{Evaluate an expression to generate the output
value.}

\item{outputSource}{Specifies one or more workflow parameters that
supply the value of to the output parameter.}

\item{linkMerge}{The method to use to merge multiple inbound links
into a single array.}

\item{pickValue}{The method to use to choose non-null elements
among multiple sources. "first_non_null", "the_only_non_null",
or "all_non_null".}

\item{out}{The default stdout parameter.}

\item{source}{Specifies one or more workflow parameters that will
provide input to the underlying step parameter.}
}
\value{
InputArrayParam: An object of class `InputArrayParam`.

An object of class `InputParam`.

InputParamList: An object of class `InputParamList`.

An object of class `OutputArrayParam`.

OutputParam: An object of class `OutputParam`.

OutputParamList: An object of class `OutputParamList`.

stepInParam: An object of class `stepInParam`.

An object of class `stepInParamList`.

cwlStepList: An object of class `cwlStepList`.
}
\description{
InputArrayParam: Parameters for array inputs. To
    specify an array parameter, the array definition is nested
    under the type field with 'type: array' and items defining the
    valid data types that may appear in the array.

InputParam: parameter for a command line tool.

InputParamList: A list of `InputParam` objects.

OutputArrayParam: Parameters for array outputs.

OutputParam: An output parameter for a Command Line
    Tool.

OutputParamList: A list of `InputParam` objects.

stepInParam: The input parameter of a workflow step.

stepInParamList: A list of `stepInParam` objects.

cwlStepList: A list of `cwlStep` objects.
}
\details{
More details of `InputArrayParam`, see:
    https://www.commonwl.org/v1.0/CommandLineTool.html#CommandInputArraySchema

More details for `InputParam`, see:
    https://www.commonwl.org/v1.0/CommandLineTool.html#CommandInputParameter

More details for `OutputArrayParam`, see:
    https://www.commonwl.org/v1.0/CommandLineTool.html#CommandOutputArraySchema

More details for `OutputParam`, see:
    https://www.commonwl.org/v1.0/CommandLineTool.html#CommandOutputParameter

More details for `stepInParam`, see:
    https://www.commonwl.org/v1.0/Workflow.html#WorkflowStepInput
}
\examples{
InputArrayParam(items = "string", prefix="-B=", separate = FALSE)
input1 <- InputParam(id = "sth")
InputParamList(input1)
OutputParam(id = "b", type = OutputArrayParam(items = "File"), glob = "*.txt")
o1 <- OutputParam(id = "file", type = "File", glob = "*.txt")
o1

o1 <- OutputParam(id = "file", type = "File", glob = "*.txt")
OutputParamList(o1)
s1 <- stepInParam(id = "s1")

s1 <- stepInParam(id = "s1")
stepInParamList(s1)
s1 <- cwlStep(id = "s1")
cwlStepList(s1)
}
