#!/usr/bin/env python
##############################################################################
#
# pyobjcryst        Complex Modeling Initiative
#                   (c) 2013 Brookhaven Science Associates,
#                   Brookhaven National Laboratory.
#                   All rights reserved.
#
# File coded by:    Pavol Juhas
#
# See AUTHORS.txt for a list of people who contributed.
# See LICENSE.txt for license information.
#
##############################################################################

"""Convenience module for executing all unit tests with

python -m pyobjcryst.tests.run
"""

if __name__ == '__main__':
    import sys
    # show warnings by default
    if not sys.warnoptions:
        import os, warnings
        warnings.simplefilter("default")
        # also affect subprocesses
        os.environ["PYTHONWARNINGS"] = "default"
    from pyobjcryst.tests import test
    # produce zero exit code for a successful test
    sys.exit(not test().wasSuccessful())
