/*
* @license Apache-2.0
*
* Copyright (c) 2019 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

import xlog1py = require( './index' );


// TESTS //

// The function returns a number...
{
	xlog1py( 8, 2 ); // $ExpectType number
}

// The function does not compile if provided values other than two numbers...
{
	xlog1py( true, 3 ); // $ExpectError
	xlog1py( false, 2 ); // $ExpectError
	xlog1py( '5', 1 ); // $ExpectError
	xlog1py( [], 1 ); // $ExpectError
	xlog1py( {}, 2 ); // $ExpectError
	xlog1py( ( x: number ): number => x, 2 ); // $ExpectError

	xlog1py( 9, true ); // $ExpectError
	xlog1py( 9, false ); // $ExpectError
	xlog1py( 5, '5' ); // $ExpectError
	xlog1py( 8, [] ); // $ExpectError
	xlog1py( 9, {} ); // $ExpectError
	xlog1py( 8, ( x: number ): number => x ); // $ExpectError

	xlog1py( [], true ); // $ExpectError
	xlog1py( {}, false ); // $ExpectError
	xlog1py( false, '5' ); // $ExpectError
	xlog1py( {}, [] ); // $ExpectError
	xlog1py( '5', ( x: number ): number => x ); // $ExpectError
}

// The function does not compile if provided insufficient arguments...
{
	xlog1py(); // $ExpectError
	xlog1py( 3 ); // $ExpectError
}
